/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class FieldConstants {
    public static final String BOOLEAN = "boolean";
    public static final String DATA_TYPE = "dataType";
    public static final String DATE = "date";
    public static final String DOCUMENT_LIBRARY = "document-library";
    public static final String DOUBLE = "double";
    public static final String EDITABLE = "editable";
    public static final String FLOAT = "float";
    public static final String HTML = "html";
    public static final String IMAGE = "image";
    public static final String INTEGER = "integer";
    public static final String LABEL = "label";
    public static final String LONG = "long";
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String PREDEFINED_VALUE = "predefinedValue";
    public static final String PRIVATE = "private";
    public static final String REQUIRED = "required";
    public static final String SHORT = "short";
    public static final String SHOW = "showLabel";
    public static final String SORTABLE = "sortable";
    public static final String STRING = "string";
    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public static final Serializable getSerializable(String type, List<Serializable> values) {
        if (type.equals(BOOLEAN)) {
            return values.toArray(new Boolean[values.size()]);
        }
        if (type.equals(DATE)) {
            return values.toArray(new Date[values.size()]);
        }
        if (type.equals(DOUBLE)) {
            return values.toArray(new Double[values.size()]);
        }
        if (type.equals(FLOAT)) {
            return values.toArray(new Float[values.size()]);
        }
        if (type.equals(INTEGER)) {
            return values.toArray(new Integer[values.size()]);
        }
        if (type.equals(LONG)) {
            return values.toArray(new Long[values.size()]);
        }
        if (type.equals(NUMBER)) {
            return values.toArray(new Number[values.size()]);
        }
        if (type.equals(SHORT)) {
            return values.toArray(new Short[values.size()]);
        }
        return values.toArray(new String[values.size()]);
    }

    public static final Serializable getSerializable(String type, String value) {
        if (FieldConstants.isNumericType(type) && Validator.isNull(value)) {
            return null;
        }
        if (type.equals(BOOLEAN)) {
            return Boolean.valueOf(GetterUtil.getBoolean(value));
        }
        if (type.equals(DATE) && Validator.isNotNull(value)) {
            return new Date(GetterUtil.getLong(value));
        }
        if (type.equals(DOUBLE)) {
            return Double.valueOf(GetterUtil.getDouble(value));
        }
        if (type.equals(FLOAT)) {
            return Float.valueOf(GetterUtil.getFloat(value));
        }
        if (type.equals(INTEGER)) {
            return Integer.valueOf(GetterUtil.getInteger(value));
        }
        if (type.equals(LONG)) {
            return Long.valueOf(GetterUtil.getLong(value));
        }
        if (type.equals(NUMBER)) {
            return GetterUtil.getNumber(value);
        }
        if (type.equals(SHORT)) {
            return Short.valueOf(GetterUtil.getShort(value));
        }
        return value;
    }

    public static final boolean isNumericType(String type) {
        return type.equals(DOUBLE) || type.equals(FLOAT) || type.equals(INTEGER) || type.equals(LONG) || type.equals(NUMBER) || type.equals(SHORT);
    }
}

