/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util.comparator;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.messageboards.model.MBThread;
import java.util.Date;

public class ThreadLastPostDateComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "MBThread.lastPostDate ASC, MBThread.threadId ASC";
    public static final String[] ORDER_BY_CONDITION_FIELDS = new String[]{"lastPostDate"};
    public static final String ORDER_BY_DESC = "MBThread.lastPostDate DESC, MBThread.threadId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"lastPostDate", "threadId"};
    private boolean _ascending;

    public ThreadLastPostDateComparator() {
        this(false);
    }

    public ThreadLastPostDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        int value;
        MBThread thread1 = (MBThread)obj1;
        MBThread thread2 = (MBThread)obj2;
        Date lastPostDate1 = thread1.getLastPostDate();
        Date lastPostDate2 = thread2.getLastPostDate();
        boolean ignoreMilliseconds = false;
        DB db = DBFactoryUtil.getDB();
        if (!db.isSupportsDateMilliseconds()) {
            ignoreMilliseconds = true;
        }
        if ((value = DateUtil.compareTo(lastPostDate1, lastPostDate2, ignoreMilliseconds)) == 0) {
            if (thread1.getThreadId() < thread2.getThreadId()) {
                value = -1;
            } else if (thread1.getThreadId() > thread2.getThreadId()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByConditionFields() {
        return ORDER_BY_CONDITION_FIELDS;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

