/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.util;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletSetupUtil;
import javax.portlet.PortletPreferences;

public class PortletConfigurationUtil {
    private static Log _log = LogFactoryUtil.getLog(PortletConfigurationUtil.class);

    public static String getPortletCustomCSSClassName(PortletPreferences portletSetup) throws Exception {
        JSONObject cssJSONObject;
        JSONObject advancedDataJSONObject;
        String customCSSClassName = "";
        String css = portletSetup.getValue("portletSetupCss", "");
        if (Validator.isNotNull(css) && (advancedDataJSONObject = (cssJSONObject = PortletSetupUtil.cssToJSONObject(portletSetup, css)).getJSONObject("advancedData")) != null) {
            customCSSClassName = advancedDataJSONObject.getString("customCSSClassName");
        }
        return customCSSClassName;
    }

    public static String getPortletTitle(PortletPreferences portletSetup, String languageId) {
        String useCustomTitle = GetterUtil.getString(portletSetup.getValue("portletSetupUseCustomTitle", ""));
        if (!useCustomTitle.equals("true")) {
            return null;
        }
        String defaultLanguageId = LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault());
        String defaultPortletTitle = portletSetup.getValue("portletSetupTitle_" + defaultLanguageId, "");
        String portletTitle = portletSetup.getValue("portletSetupTitle_" + languageId, defaultPortletTitle);
        if (Validator.isNotNull(portletTitle)) {
            return portletTitle;
        }
        String oldPortletTitle = portletSetup.getValue("portletSetupTitle", null);
        if (Validator.isNull(useCustomTitle) && Validator.isNotNull(oldPortletTitle)) {
            portletTitle = oldPortletTitle;
            try {
                portletSetup.setValue("portletSetupTitle_" + defaultLanguageId, portletTitle);
                portletSetup.setValue("portletSetupUseCustomTitle", Boolean.TRUE.toString());
                portletSetup.store();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return portletTitle;
    }
}

