/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.model;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.SocialRequest;
import com.liferay.portlet.social.model.SocialRequestFeedEntry;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.service.persistence.SocialRequestUtil;
import java.util.List;

public abstract class BaseSocialRequestInterpreter
implements SocialRequestInterpreter {
    private static Log _log = LogFactoryUtil.getLog(BaseSocialRequestInterpreter.class);

    public String getUserName(long userId, ThemeDisplay themeDisplay) {
        block5: {
            try {
                if (userId > 0L) break block5;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        User user = UserLocalServiceUtil.getUserById(userId);
        if (user.getUserId() == themeDisplay.getUserId()) {
            return HtmlUtil.escape(user.getFirstName());
        }
        String userName = user.getFullName();
        Group group = user.getGroup();
        if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
            return HtmlUtil.escape(userName);
        }
        String userDisplayURL = user.getDisplayURL(themeDisplay);
        return "<a href=\"" + userDisplayURL + "\">" + HtmlUtil.escape(userName) + "</a>";
    }

    public String getUserNameLink(long userId, ThemeDisplay themeDisplay) {
        block3: {
            try {
                if (userId > 0L) break block3;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        User user = UserLocalServiceUtil.getUserById(userId);
        String userName = user.getFullName();
        String userDisplayURL = user.getDisplayURL(themeDisplay);
        return "<a href=\"" + userDisplayURL + "\">" + HtmlUtil.escape(userName) + "</a>";
    }

    @Override
    public SocialRequestFeedEntry interpret(SocialRequest request, ThemeDisplay themeDisplay) {
        try {
            return this.doInterpret(request, themeDisplay);
        }
        catch (Exception e) {
            _log.error("Unable to interpret request", e);
            return null;
        }
    }

    @Override
    public boolean processConfirmation(SocialRequest request, ThemeDisplay themeDisplay) {
        try {
            return this.doProcessConfirmation(request, themeDisplay);
        }
        catch (Exception e) {
            _log.error("Unable to process confirmation", e);
            return false;
        }
    }

    public void processDuplicateRequestsFromUser(SocialRequest request, int oldStatus) throws SystemException {
        List<SocialRequest> requests = SocialRequestUtil.findByU_C_C_T_S(request.getUserId(), request.getClassNameId(), request.getClassPK(), request.getType(), oldStatus);
        int newStatus = request.getStatus();
        for (SocialRequest curRequest : requests) {
            curRequest.setStatus(newStatus);
            SocialRequestUtil.update(curRequest);
        }
    }

    public void processDuplicateRequestsToUser(SocialRequest request, int oldStatus) throws SystemException {
        List<SocialRequest> requests = SocialRequestUtil.findByC_C_T_R_S(request.getClassNameId(), request.getClassPK(), request.getType(), request.getReceiverUserId(), oldStatus);
        int newStatus = request.getStatus();
        for (SocialRequest curRequest : requests) {
            curRequest.setStatus(newStatus);
            SocialRequestUtil.update(curRequest);
        }
    }

    @Override
    public boolean processRejection(SocialRequest request, ThemeDisplay themeDisplay) {
        try {
            return this.doProcessRejection(request, themeDisplay);
        }
        catch (Exception e) {
            _log.error("Unable to process rejection", e);
            return false;
        }
    }

    protected abstract SocialRequestFeedEntry doInterpret(SocialRequest var1, ThemeDisplay var2) throws Exception;

    protected abstract boolean doProcessConfirmation(SocialRequest var1, ThemeDisplay var2) throws Exception;

    protected boolean doProcessRejection(SocialRequest request, ThemeDisplay themeDisplay) throws Exception {
        return true;
    }
}

