/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import java.util.Collection;

public class BulkException
extends Exception {
    private final Collection<Throwable> _causes;

    public BulkException(String message, Collection<Throwable> causes) {
        super(message);
        this._causes = causes;
    }

    public Collection<Throwable> getCauses() {
        return this._causes;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(7 * this._causes.size() + 4);
        sb.append("{message = ");
        sb.append(super.getMessage());
        sb.append("\n");
        for (Throwable cause : this._causes) {
            sb.append("{");
            sb.append(ClassUtil.getClassName(cause));
            sb.append(":");
            sb.append(cause.getMessage());
            sb.append(", ");
            sb.append(StackTraceUtil.getStackTrace(cause));
            sb.append("}\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

