/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class CompositeHitsProcessor
implements HitsProcessor {
    private List<HitsProcessor> _hitsProcessors;

    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        if (Validator.isNull(searchContext.getKeywords())) {
            return false;
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isHitsProcessingEnabled()) {
            return false;
        }
        for (HitsProcessor hitsProcessor : this._hitsProcessors) {
            if (!hitsProcessor.process(searchContext, hits)) break;
        }
        return true;
    }

    public void setHitsProcessors(List<HitsProcessor> hitsProcessors) {
        this._hitsProcessors = hitsProcessors;
    }
}

