/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;

public class StagedModelType {
    public static final int REFERRER_CLASS_NAME_ID_ALL = -1;
    private String _className;
    private long _classNameId;
    private String _classSimpleName;
    private String _referrerClassName;
    private long _referrerClassNameId;

    public StagedModelType(Class<?> clazz) {
        this.setClassName(clazz.getName());
    }

    public StagedModelType(Class<?> clazz, Class<?> referrerClass) {
        this.setClassName(clazz.getName());
        this.setReferrerClassName(referrerClass.getName());
    }

    public StagedModelType(long classNameId) {
        this.setClassNameId(classNameId);
    }

    public StagedModelType(long classNameId, long referrerClassNameId) {
        this.setClassNameId(classNameId);
        this.setReferrerClassNameId(referrerClassNameId);
    }

    public StagedModelType(String className) {
        this.setClassName(className);
    }

    public StagedModelType(String className, String referrerClassName) {
        this.setClassName(className);
        this.setReferrerClassName(referrerClassName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof StagedModelType)) {
            return false;
        }
        StagedModelType stagedModelType = (StagedModelType)obj;
        return stagedModelType._classNameId == this._classNameId && stagedModelType._referrerClassNameId == this._referrerClassNameId;
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassNameId() {
        return this._classNameId;
    }

    public String getClassSimpleName() {
        return this._classSimpleName;
    }

    public String getReferrerClassName() {
        return this._referrerClassName;
    }

    public long getReferrerClassNameId() {
        return this._referrerClassNameId;
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this._classNameId);
        hashCode.append(this._referrerClassNameId);
        return hashCode.toHashCode();
    }

    public void setClassName(String className) {
        this._className = className;
        this._classSimpleName = this.getSimpleName(this._className);
        this._classNameId = Validator.isNotNull(className) ? PortalUtil.getClassNameId(className) : 0L;
    }

    public void setClassNameId(long classNameId) {
        if (classNameId > 0L) {
            this._className = PortalUtil.getClassName(classNameId);
            this._classSimpleName = this.getSimpleName(this._className);
        } else {
            this._className = null;
            this._classSimpleName = null;
        }
        this._classNameId = classNameId;
    }

    public void setClassSimpleName(String classSimpleName) {
        this._classSimpleName = classSimpleName;
    }

    public void setReferrerClassName(String referrerClassName) {
        this._referrerClassName = referrerClassName;
        this._referrerClassNameId = Validator.isNotNull(referrerClassName) ? PortalUtil.getClassNameId(referrerClassName) : 0L;
    }

    public void setReferrerClassNameId(long referrerClassNameId) {
        this._referrerClassName = referrerClassNameId > 0L ? PortalUtil.getClassName(referrerClassNameId) : null;
        this._referrerClassNameId = referrerClassNameId;
    }

    public String toString() {
        if (this._referrerClassNameId <= 0L) {
            return this._className;
        }
        return this._className.concat("#").concat(this._referrerClassName);
    }

    private String getSimpleName(String className) {
        int pos = className.lastIndexOf(".") + 1;
        return className.substring(pos);
    }
}

