/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.management;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.management.ManageAction;
import com.liferay.portal.kernel.management.ManageActionException;
import com.liferay.portal.kernel.management.PortalManagerUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.model.ClusterGroup;
import java.util.Iterator;
import java.util.List;

public class ClusterManageActionWrapper
implements ManageAction<FutureClusterResponses> {
    private ClusterGroup _clusterGroup;
    private ManageAction<?> _manageAction;

    public ClusterManageActionWrapper(ClusterGroup clusterGroup, ManageAction<?> manageAction) {
        this._clusterGroup = clusterGroup;
        this._manageAction = manageAction;
    }

    @Override
    public FutureClusterResponses action() throws ManageActionException {
        try {
            return this.doAction();
        }
        catch (SystemException se) {
            throw new ManageActionException("Failed to execute cluster manage action", se);
        }
    }

    protected FutureClusterResponses doAction() throws ManageActionException, SystemException {
        MethodHandler manageActionMethodHandler = PortalManagerUtil.createManageActionMethodHandler(this._manageAction);
        ClusterRequest clusterRequest = null;
        if (this._clusterGroup.isWholeCluster()) {
            clusterRequest = ClusterRequest.createMulticastRequest(manageActionMethodHandler);
        } else {
            this.verifyClusterGroup();
            clusterRequest = ClusterRequest.createUnicastRequest(manageActionMethodHandler, this._clusterGroup.getClusterNodeIdsArray());
        }
        return ClusterExecutorUtil.execute(clusterRequest);
    }

    protected void verifyClusterGroup() throws ManageActionException {
        String[] requiredClusterNodesIds;
        List<ClusterNode> clusterNodes = ClusterExecutorUtil.getClusterNodes();
        String[] stringArray = requiredClusterNodesIds = this._clusterGroup.getClusterNodeIdsArray();
        int n = requiredClusterNodesIds.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredClusterNodeId = stringArray[n2];
            boolean verified = false;
            Iterator<ClusterNode> itr = clusterNodes.iterator();
            while (itr.hasNext()) {
                ClusterNode clusterNode = itr.next();
                String clusterNodeId = clusterNode.getClusterNodeId();
                if (!clusterNodeId.equals(requiredClusterNodeId)) continue;
                itr.remove();
                verified = true;
                break;
            }
            if (!verified) {
                throw new ManageActionException("Cluster node " + requiredClusterNodeId + " is not available");
            }
            ++n2;
        }
    }
}

