/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodKey;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodCache {
    private static Map<MethodKey, Method> _methods = new ConcurrentHashMap<MethodKey, Method>();

    public static void reset() {
        _methods.clear();
    }

    protected static Method get(MethodKey methodKey) throws NoSuchMethodException {
        Method method = _methods.get(methodKey);
        if (method == null) {
            Class<?> declaringClass = methodKey.getDeclaringClass();
            method = declaringClass.getDeclaredMethod(methodKey.getMethodName(), methodKey.getParameterTypes());
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            _methods.put(methodKey, method);
        }
        return method;
    }
}

