/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

import getDataAttributes from './get_data_attributes';

function addSeparators(items) {
	if (items.length < 2) {
		return items;
	}

	const separatedItems = [items[0]];

	for (let i = 1; i < items.length; i++) {
		const item = items[i];

		if (item.type === 'group' && item.separator) {
			separatedItems.push({type: 'divider'});
		}

		separatedItems.push(item);
	}

	return separatedItems.map((item) => {
		if (item.type === 'group') {
			return {
				...item,
				items: addSeparators(item.items),
			};
		}

		return item;
	});
}

function filterEmptyGroups(items) {
	return items
		.filter(
			(item) =>
				item.type !== 'group' ||
				(Array.isArray(item.items) && item.items.length)
		)
		.map((item) =>
			item.type === 'group'
				? {...item, items: filterEmptyGroups(item.items)}
				: item
		);
}

function spreadDataAttributes(item) {
	const {data, ...rest} = item;

	const dataAttributes = getDataAttributes(data);

	const items = Array.isArray(item.items)
		? item.items.map(spreadDataAttributes)
		: item.items;

	return {
		...dataAttributes,
		...rest,
		items,
	};
}

export default function normalizeDropdownItems(items) {
	if (!items) {
		return null;
	}

	const filteredItems = filterEmptyGroups(items);

	if (filteredItems.length === 0) {
		return [];
	}

	return addSeparators(filteredItems.map(spreadDataAttributes));
}
