/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutRevisionModel;
import com.liferay.portal.kernel.model.LayoutRevisionSoap;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutRevision service. Represents a row in the &quot;LayoutRevision&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutRevisionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutRevisionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutRevisionImpl
 * @generated
 */
@JSON(strict = true)
public class LayoutRevisionModelImpl
	extends BaseModelImpl<LayoutRevision> implements LayoutRevisionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout revision model instance should use the <code>LayoutRevision</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutRevision";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"layoutRevisionId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"layoutSetBranchId", Types.BIGINT}, {"layoutBranchId", Types.BIGINT},
		{"parentLayoutRevisionId", Types.BIGINT}, {"head", Types.BOOLEAN},
		{"major", Types.BOOLEAN}, {"plid", Types.BIGINT},
		{"privateLayout", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"title", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"keywords", Types.VARCHAR}, {"robots", Types.VARCHAR},
		{"typeSettings", Types.CLOB}, {"iconImageId", Types.BIGINT},
		{"themeId", Types.VARCHAR}, {"colorSchemeId", Types.VARCHAR},
		{"css", Types.CLOB}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutRevisionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("layoutSetBranchId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutBranchId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentLayoutRevisionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("head", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("major", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("privateLayout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("keywords", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("robots", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("iconImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("themeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("colorSchemeId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("css", Types.CLOB);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutRevision (mvccVersion LONG default 0 not null,layoutRevisionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,layoutSetBranchId LONG,layoutBranchId LONG,parentLayoutRevisionId LONG,head BOOLEAN,major BOOLEAN,plid LONG,privateLayout BOOLEAN,name STRING null,title STRING null,description STRING null,keywords STRING null,robots STRING null,typeSettings TEXT null,iconImageId LONG,themeId VARCHAR(75) null,colorSchemeId VARCHAR(75) null,css TEXT null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table LayoutRevision";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutRevision.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutRevision.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long HEAD_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTBRANCHID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSETBRANCHID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTLAYOUTREVISIONID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 64L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static LayoutRevision toModel(LayoutRevisionSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		LayoutRevision model = new LayoutRevisionImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setLayoutRevisionId(soapModel.getLayoutRevisionId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setLayoutSetBranchId(soapModel.getLayoutSetBranchId());
		model.setLayoutBranchId(soapModel.getLayoutBranchId());
		model.setParentLayoutRevisionId(soapModel.getParentLayoutRevisionId());
		model.setHead(soapModel.isHead());
		model.setMajor(soapModel.isMajor());
		model.setPlid(soapModel.getPlid());
		model.setPrivateLayout(soapModel.isPrivateLayout());
		model.setName(soapModel.getName());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setKeywords(soapModel.getKeywords());
		model.setRobots(soapModel.getRobots());
		model.setTypeSettings(soapModel.getTypeSettings());
		model.setIconImageId(soapModel.getIconImageId());
		model.setThemeId(soapModel.getThemeId());
		model.setColorSchemeId(soapModel.getColorSchemeId());
		model.setCss(soapModel.getCss());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<LayoutRevision> toModels(
		LayoutRevisionSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<LayoutRevision> models = new ArrayList<LayoutRevision>(
			soapModels.length);

		for (LayoutRevisionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.LayoutRevision"));

	public LayoutRevisionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutRevisionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutRevisionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutRevisionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutRevision.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutRevision.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutRevision, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutRevision, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutRevision, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutRevision)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutRevision, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutRevision, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutRevision)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutRevision, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutRevision, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, LayoutRevision>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			LayoutRevision.class.getClassLoader(), LayoutRevision.class,
			ModelWrapper.class);

		try {
			Constructor<LayoutRevision> constructor =
				(Constructor<LayoutRevision>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<LayoutRevision, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<LayoutRevision, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<LayoutRevision, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<LayoutRevision, Object>>();
		Map<String, BiConsumer<LayoutRevision, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<LayoutRevision, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", LayoutRevision::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<LayoutRevision, Long>)LayoutRevision::setMvccVersion);
		attributeGetterFunctions.put(
			"layoutRevisionId", LayoutRevision::getLayoutRevisionId);
		attributeSetterBiConsumers.put(
			"layoutRevisionId",
			(BiConsumer<LayoutRevision, Long>)
				LayoutRevision::setLayoutRevisionId);
		attributeGetterFunctions.put("groupId", LayoutRevision::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<LayoutRevision, Long>)LayoutRevision::setGroupId);
		attributeGetterFunctions.put("companyId", LayoutRevision::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<LayoutRevision, Long>)LayoutRevision::setCompanyId);
		attributeGetterFunctions.put("userId", LayoutRevision::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<LayoutRevision, Long>)LayoutRevision::setUserId);
		attributeGetterFunctions.put("userName", LayoutRevision::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setUserName);
		attributeGetterFunctions.put(
			"createDate", LayoutRevision::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<LayoutRevision, Date>)LayoutRevision::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", LayoutRevision::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<LayoutRevision, Date>)LayoutRevision::setModifiedDate);
		attributeGetterFunctions.put(
			"layoutSetBranchId", LayoutRevision::getLayoutSetBranchId);
		attributeSetterBiConsumers.put(
			"layoutSetBranchId",
			(BiConsumer<LayoutRevision, Long>)
				LayoutRevision::setLayoutSetBranchId);
		attributeGetterFunctions.put(
			"layoutBranchId", LayoutRevision::getLayoutBranchId);
		attributeSetterBiConsumers.put(
			"layoutBranchId",
			(BiConsumer<LayoutRevision, Long>)
				LayoutRevision::setLayoutBranchId);
		attributeGetterFunctions.put(
			"parentLayoutRevisionId",
			LayoutRevision::getParentLayoutRevisionId);
		attributeSetterBiConsumers.put(
			"parentLayoutRevisionId",
			(BiConsumer<LayoutRevision, Long>)
				LayoutRevision::setParentLayoutRevisionId);
		attributeGetterFunctions.put("head", LayoutRevision::getHead);
		attributeSetterBiConsumers.put(
			"head",
			(BiConsumer<LayoutRevision, Boolean>)LayoutRevision::setHead);
		attributeGetterFunctions.put("major", LayoutRevision::getMajor);
		attributeSetterBiConsumers.put(
			"major",
			(BiConsumer<LayoutRevision, Boolean>)LayoutRevision::setMajor);
		attributeGetterFunctions.put("plid", LayoutRevision::getPlid);
		attributeSetterBiConsumers.put(
			"plid", (BiConsumer<LayoutRevision, Long>)LayoutRevision::setPlid);
		attributeGetterFunctions.put(
			"privateLayout", LayoutRevision::getPrivateLayout);
		attributeSetterBiConsumers.put(
			"privateLayout",
			(BiConsumer<LayoutRevision, Boolean>)
				LayoutRevision::setPrivateLayout);
		attributeGetterFunctions.put("name", LayoutRevision::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setName);
		attributeGetterFunctions.put("title", LayoutRevision::getTitle);
		attributeSetterBiConsumers.put(
			"title",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setTitle);
		attributeGetterFunctions.put(
			"description", LayoutRevision::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setDescription);
		attributeGetterFunctions.put("keywords", LayoutRevision::getKeywords);
		attributeSetterBiConsumers.put(
			"keywords",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setKeywords);
		attributeGetterFunctions.put("robots", LayoutRevision::getRobots);
		attributeSetterBiConsumers.put(
			"robots",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setRobots);
		attributeGetterFunctions.put(
			"typeSettings", LayoutRevision::getTypeSettings);
		attributeSetterBiConsumers.put(
			"typeSettings",
			(BiConsumer<LayoutRevision, String>)
				LayoutRevision::setTypeSettings);
		attributeGetterFunctions.put(
			"iconImageId", LayoutRevision::getIconImageId);
		attributeSetterBiConsumers.put(
			"iconImageId",
			(BiConsumer<LayoutRevision, Long>)LayoutRevision::setIconImageId);
		attributeGetterFunctions.put("themeId", LayoutRevision::getThemeId);
		attributeSetterBiConsumers.put(
			"themeId",
			(BiConsumer<LayoutRevision, String>)LayoutRevision::setThemeId);
		attributeGetterFunctions.put(
			"colorSchemeId", LayoutRevision::getColorSchemeId);
		attributeSetterBiConsumers.put(
			"colorSchemeId",
			(BiConsumer<LayoutRevision, String>)
				LayoutRevision::setColorSchemeId);
		attributeGetterFunctions.put("css", LayoutRevision::getCss);
		attributeSetterBiConsumers.put(
			"css", (BiConsumer<LayoutRevision, String>)LayoutRevision::setCss);
		attributeGetterFunctions.put("status", LayoutRevision::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<LayoutRevision, Integer>)LayoutRevision::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", LayoutRevision::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<LayoutRevision, Long>)
				LayoutRevision::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", LayoutRevision::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<LayoutRevision, String>)
				LayoutRevision::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", LayoutRevision::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<LayoutRevision, Date>)LayoutRevision::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getLayoutRevisionId() {
		return _layoutRevisionId;
	}

	@Override
	public void setLayoutRevisionId(long layoutRevisionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutRevisionId = layoutRevisionId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getLayoutSetBranchId() {
		return _layoutSetBranchId;
	}

	@Override
	public void setLayoutSetBranchId(long layoutSetBranchId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSetBranchId = layoutSetBranchId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutSetBranchId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutSetBranchId"));
	}

	@JSON
	@Override
	public long getLayoutBranchId() {
		return _layoutBranchId;
	}

	@Override
	public void setLayoutBranchId(long layoutBranchId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutBranchId = layoutBranchId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutBranchId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutBranchId"));
	}

	@JSON
	@Override
	public long getParentLayoutRevisionId() {
		return _parentLayoutRevisionId;
	}

	@Override
	public void setParentLayoutRevisionId(long parentLayoutRevisionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentLayoutRevisionId = parentLayoutRevisionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentLayoutRevisionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentLayoutRevisionId"));
	}

	@JSON
	@Override
	public boolean getHead() {
		return _head;
	}

	@JSON
	@Override
	public boolean isHead() {
		return _head;
	}

	@Override
	public void setHead(boolean head) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_head = head;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalHead() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("head"));
	}

	@JSON
	@Override
	public boolean getMajor() {
		return _major;
	}

	@JSON
	@Override
	public boolean isMajor() {
		return _major;
	}

	@Override
	public void setMajor(boolean major) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_major = major;
	}

	@JSON
	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@JSON
	@Override
	public boolean getPrivateLayout() {
		return _privateLayout;
	}

	@JSON
	@Override
	public boolean isPrivateLayout() {
		return _privateLayout;
	}

	@Override
	public void setPrivateLayout(boolean privateLayout) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_privateLayout = privateLayout;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTitle(), languageId, useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(
				LocalizationUtil.updateLocalization(
					getTitle(), "Title", title, languageId, defaultLanguageId));
		}
		else {
			setTitle(
				LocalizationUtil.removeLocalization(
					getTitle(), "Title", languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitleMap(
		Map<Locale, String> titleMap, Locale defaultLocale) {

		if (titleMap == null) {
			return;
		}

		setTitle(
			LocalizationUtil.updateLocalization(
				titleMap, getTitle(), "Title",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getKeywords() {
		if (_keywords == null) {
			return "";
		}
		else {
			return _keywords;
		}
	}

	@Override
	public String getKeywords(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId);
	}

	@Override
	public String getKeywords(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getKeywords(languageId, useDefault);
	}

	@Override
	public String getKeywords(String languageId) {
		return LocalizationUtil.getLocalization(getKeywords(), languageId);
	}

	@Override
	public String getKeywords(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getKeywords(), languageId, useDefault);
	}

	@Override
	public String getKeywordsCurrentLanguageId() {
		return _keywordsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getKeywordsCurrentValue() {
		Locale locale = getLocale(_keywordsCurrentLanguageId);

		return getKeywords(locale);
	}

	@Override
	public Map<Locale, String> getKeywordsMap() {
		return LocalizationUtil.getLocalizationMap(getKeywords());
	}

	@Override
	public void setKeywords(String keywords) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_keywords = keywords;
	}

	@Override
	public void setKeywords(String keywords, Locale locale) {
		setKeywords(keywords, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywords(
		String keywords, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(keywords)) {
			setKeywords(
				LocalizationUtil.updateLocalization(
					getKeywords(), "Keywords", keywords, languageId,
					defaultLanguageId));
		}
		else {
			setKeywords(
				LocalizationUtil.removeLocalization(
					getKeywords(), "Keywords", languageId));
		}
	}

	@Override
	public void setKeywordsCurrentLanguageId(String languageId) {
		_keywordsCurrentLanguageId = languageId;
	}

	@Override
	public void setKeywordsMap(Map<Locale, String> keywordsMap) {
		setKeywordsMap(keywordsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setKeywordsMap(
		Map<Locale, String> keywordsMap, Locale defaultLocale) {

		if (keywordsMap == null) {
			return;
		}

		setKeywords(
			LocalizationUtil.updateLocalization(
				keywordsMap, getKeywords(), "Keywords",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getRobots() {
		if (_robots == null) {
			return "";
		}
		else {
			return _robots;
		}
	}

	@Override
	public String getRobots(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId);
	}

	@Override
	public String getRobots(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getRobots(languageId, useDefault);
	}

	@Override
	public String getRobots(String languageId) {
		return LocalizationUtil.getLocalization(getRobots(), languageId);
	}

	@Override
	public String getRobots(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getRobots(), languageId, useDefault);
	}

	@Override
	public String getRobotsCurrentLanguageId() {
		return _robotsCurrentLanguageId;
	}

	@JSON
	@Override
	public String getRobotsCurrentValue() {
		Locale locale = getLocale(_robotsCurrentLanguageId);

		return getRobots(locale);
	}

	@Override
	public Map<Locale, String> getRobotsMap() {
		return LocalizationUtil.getLocalizationMap(getRobots());
	}

	@Override
	public void setRobots(String robots) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_robots = robots;
	}

	@Override
	public void setRobots(String robots, Locale locale) {
		setRobots(robots, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobots(String robots, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(robots)) {
			setRobots(
				LocalizationUtil.updateLocalization(
					getRobots(), "Robots", robots, languageId,
					defaultLanguageId));
		}
		else {
			setRobots(
				LocalizationUtil.removeLocalization(
					getRobots(), "Robots", languageId));
		}
	}

	@Override
	public void setRobotsCurrentLanguageId(String languageId) {
		_robotsCurrentLanguageId = languageId;
	}

	@Override
	public void setRobotsMap(Map<Locale, String> robotsMap) {
		setRobotsMap(robotsMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setRobotsMap(
		Map<Locale, String> robotsMap, Locale defaultLocale) {

		if (robotsMap == null) {
			return;
		}

		setRobots(
			LocalizationUtil.updateLocalization(
				robotsMap, getRobots(), "Robots",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getTypeSettings() {
		if (_typeSettings == null) {
			return "";
		}
		else {
			return _typeSettings;
		}
	}

	@Override
	public void setTypeSettings(String typeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeSettings = typeSettings;
	}

	@JSON
	@Override
	public long getIconImageId() {
		return _iconImageId;
	}

	@Override
	public void setIconImageId(long iconImageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_iconImageId = iconImageId;
	}

	@JSON
	@Override
	public String getThemeId() {
		if (_themeId == null) {
			return "";
		}
		else {
			return _themeId;
		}
	}

	@Override
	public void setThemeId(String themeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_themeId = themeId;
	}

	@JSON
	@Override
	public String getColorSchemeId() {
		if (_colorSchemeId == null) {
			return "";
		}
		else {
			return _colorSchemeId;
		}
	}

	@Override
	public void setColorSchemeId(String colorSchemeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_colorSchemeId = colorSchemeId;
	}

	@JSON
	@Override
	public String getCss() {
		if (_css == null) {
			return "";
		}
		else {
			return _css;
		}
	}

	@Override
	public void setCss(String css) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_css = css;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutRevision.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> keywordsMap = getKeywordsMap();

		for (Map.Entry<Locale, String> entry : keywordsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> robotsMap = getRobotsMap();

		for (Map.Entry<Locale, String> entry : robotsMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			LayoutRevision.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}

		String keywords = getKeywords(defaultLocale);

		if (Validator.isNull(keywords)) {
			setKeywords(getKeywords(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setKeywords(
				getKeywords(defaultLocale), defaultLocale, defaultLocale);
		}

		String robots = getRobots(defaultLocale);

		if (Validator.isNull(robots)) {
			setRobots(getRobots(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setRobots(getRobots(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public LayoutRevision toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutRevision>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutRevisionImpl layoutRevisionImpl = new LayoutRevisionImpl();

		layoutRevisionImpl.setMvccVersion(getMvccVersion());
		layoutRevisionImpl.setLayoutRevisionId(getLayoutRevisionId());
		layoutRevisionImpl.setGroupId(getGroupId());
		layoutRevisionImpl.setCompanyId(getCompanyId());
		layoutRevisionImpl.setUserId(getUserId());
		layoutRevisionImpl.setUserName(getUserName());
		layoutRevisionImpl.setCreateDate(getCreateDate());
		layoutRevisionImpl.setModifiedDate(getModifiedDate());
		layoutRevisionImpl.setLayoutSetBranchId(getLayoutSetBranchId());
		layoutRevisionImpl.setLayoutBranchId(getLayoutBranchId());
		layoutRevisionImpl.setParentLayoutRevisionId(
			getParentLayoutRevisionId());
		layoutRevisionImpl.setHead(isHead());
		layoutRevisionImpl.setMajor(isMajor());
		layoutRevisionImpl.setPlid(getPlid());
		layoutRevisionImpl.setPrivateLayout(isPrivateLayout());
		layoutRevisionImpl.setName(getName());
		layoutRevisionImpl.setTitle(getTitle());
		layoutRevisionImpl.setDescription(getDescription());
		layoutRevisionImpl.setKeywords(getKeywords());
		layoutRevisionImpl.setRobots(getRobots());
		layoutRevisionImpl.setTypeSettings(getTypeSettings());
		layoutRevisionImpl.setIconImageId(getIconImageId());
		layoutRevisionImpl.setThemeId(getThemeId());
		layoutRevisionImpl.setColorSchemeId(getColorSchemeId());
		layoutRevisionImpl.setCss(getCss());
		layoutRevisionImpl.setStatus(getStatus());
		layoutRevisionImpl.setStatusByUserId(getStatusByUserId());
		layoutRevisionImpl.setStatusByUserName(getStatusByUserName());
		layoutRevisionImpl.setStatusDate(getStatusDate());

		layoutRevisionImpl.resetOriginalValues();

		return layoutRevisionImpl;
	}

	@Override
	public int compareTo(LayoutRevision layoutRevision) {
		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), layoutRevision.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutRevision)) {
			return false;
		}

		LayoutRevision layoutRevision = (LayoutRevision)object;

		long primaryKey = layoutRevision.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutRevision> toCacheModel() {
		LayoutRevisionCacheModel layoutRevisionCacheModel =
			new LayoutRevisionCacheModel();

		layoutRevisionCacheModel.mvccVersion = getMvccVersion();

		layoutRevisionCacheModel.layoutRevisionId = getLayoutRevisionId();

		layoutRevisionCacheModel.groupId = getGroupId();

		layoutRevisionCacheModel.companyId = getCompanyId();

		layoutRevisionCacheModel.userId = getUserId();

		layoutRevisionCacheModel.userName = getUserName();

		String userName = layoutRevisionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			layoutRevisionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutRevisionCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutRevisionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutRevisionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			layoutRevisionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutRevisionCacheModel.layoutSetBranchId = getLayoutSetBranchId();

		layoutRevisionCacheModel.layoutBranchId = getLayoutBranchId();

		layoutRevisionCacheModel.parentLayoutRevisionId =
			getParentLayoutRevisionId();

		layoutRevisionCacheModel.head = isHead();

		layoutRevisionCacheModel.major = isMajor();

		layoutRevisionCacheModel.plid = getPlid();

		layoutRevisionCacheModel.privateLayout = isPrivateLayout();

		layoutRevisionCacheModel.name = getName();

		String name = layoutRevisionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			layoutRevisionCacheModel.name = null;
		}

		layoutRevisionCacheModel.title = getTitle();

		String title = layoutRevisionCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			layoutRevisionCacheModel.title = null;
		}

		layoutRevisionCacheModel.description = getDescription();

		String description = layoutRevisionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			layoutRevisionCacheModel.description = null;
		}

		layoutRevisionCacheModel.keywords = getKeywords();

		String keywords = layoutRevisionCacheModel.keywords;

		if ((keywords != null) && (keywords.length() == 0)) {
			layoutRevisionCacheModel.keywords = null;
		}

		layoutRevisionCacheModel.robots = getRobots();

		String robots = layoutRevisionCacheModel.robots;

		if ((robots != null) && (robots.length() == 0)) {
			layoutRevisionCacheModel.robots = null;
		}

		layoutRevisionCacheModel.typeSettings = getTypeSettings();

		String typeSettings = layoutRevisionCacheModel.typeSettings;

		if ((typeSettings != null) && (typeSettings.length() == 0)) {
			layoutRevisionCacheModel.typeSettings = null;
		}

		layoutRevisionCacheModel.iconImageId = getIconImageId();

		layoutRevisionCacheModel.themeId = getThemeId();

		String themeId = layoutRevisionCacheModel.themeId;

		if ((themeId != null) && (themeId.length() == 0)) {
			layoutRevisionCacheModel.themeId = null;
		}

		layoutRevisionCacheModel.colorSchemeId = getColorSchemeId();

		String colorSchemeId = layoutRevisionCacheModel.colorSchemeId;

		if ((colorSchemeId != null) && (colorSchemeId.length() == 0)) {
			layoutRevisionCacheModel.colorSchemeId = null;
		}

		layoutRevisionCacheModel.css = getCss();

		String css = layoutRevisionCacheModel.css;

		if ((css != null) && (css.length() == 0)) {
			layoutRevisionCacheModel.css = null;
		}

		layoutRevisionCacheModel.status = getStatus();

		layoutRevisionCacheModel.statusByUserId = getStatusByUserId();

		layoutRevisionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = layoutRevisionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			layoutRevisionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			layoutRevisionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			layoutRevisionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return layoutRevisionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutRevision, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutRevision, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutRevision, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((LayoutRevision)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<LayoutRevision, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<LayoutRevision, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutRevision, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((LayoutRevision)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, LayoutRevision>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _layoutRevisionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _layoutSetBranchId;
	private long _layoutBranchId;
	private long _parentLayoutRevisionId;
	private boolean _head;
	private boolean _major;
	private long _plid;
	private boolean _privateLayout;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _keywords;
	private String _keywordsCurrentLanguageId;
	private String _robots;
	private String _robotsCurrentLanguageId;
	private String _typeSettings;
	private long _iconImageId;
	private String _themeId;
	private String _colorSchemeId;
	private String _css;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		Function<LayoutRevision, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutRevision)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("layoutRevisionId", _layoutRevisionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("layoutSetBranchId", _layoutSetBranchId);
		_columnOriginalValues.put("layoutBranchId", _layoutBranchId);
		_columnOriginalValues.put(
			"parentLayoutRevisionId", _parentLayoutRevisionId);
		_columnOriginalValues.put("head", _head);
		_columnOriginalValues.put("major", _major);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("privateLayout", _privateLayout);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("keywords", _keywords);
		_columnOriginalValues.put("robots", _robots);
		_columnOriginalValues.put("typeSettings", _typeSettings);
		_columnOriginalValues.put("iconImageId", _iconImageId);
		_columnOriginalValues.put("themeId", _themeId);
		_columnOriginalValues.put("colorSchemeId", _colorSchemeId);
		_columnOriginalValues.put("css", _css);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("layoutRevisionId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("layoutSetBranchId", 256L);

		columnBitmasks.put("layoutBranchId", 512L);

		columnBitmasks.put("parentLayoutRevisionId", 1024L);

		columnBitmasks.put("head", 2048L);

		columnBitmasks.put("major", 4096L);

		columnBitmasks.put("plid", 8192L);

		columnBitmasks.put("privateLayout", 16384L);

		columnBitmasks.put("name", 32768L);

		columnBitmasks.put("title", 65536L);

		columnBitmasks.put("description", 131072L);

		columnBitmasks.put("keywords", 262144L);

		columnBitmasks.put("robots", 524288L);

		columnBitmasks.put("typeSettings", 1048576L);

		columnBitmasks.put("iconImageId", 2097152L);

		columnBitmasks.put("themeId", 4194304L);

		columnBitmasks.put("colorSchemeId", 8388608L);

		columnBitmasks.put("css", 16777216L);

		columnBitmasks.put("status", 33554432L);

		columnBitmasks.put("statusByUserId", 67108864L);

		columnBitmasks.put("statusByUserName", 134217728L);

		columnBitmasks.put("statusDate", 268435456L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutRevision _escapedModel;

}