/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.service.base;

import com.liferay.document.library.kernel.service.persistence.DLFileEntryTypeFinder;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryTypePersistence;
import com.liferay.expando.kernel.service.persistence.ExpandoColumnPersistence;
import com.liferay.expando.kernel.service.persistence.ExpandoTablePersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.CompanyServiceUtil;
import com.liferay.portal.kernel.service.persistence.AccountPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyInfoPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.ContactPersistence;
import com.liferay.portal.kernel.service.persistence.GroupFinder;
import com.liferay.portal.kernel.service.persistence.GroupPersistence;
import com.liferay.portal.kernel.service.persistence.ImagePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutPrototypePersistence;
import com.liferay.portal.kernel.service.persistence.LayoutSetPrototypePersistence;
import com.liferay.portal.kernel.service.persistence.OrganizationFinder;
import com.liferay.portal.kernel.service.persistence.OrganizationPersistence;
import com.liferay.portal.kernel.service.persistence.PasswordPolicyFinder;
import com.liferay.portal.kernel.service.persistence.PasswordPolicyPersistence;
import com.liferay.portal.kernel.service.persistence.PortalPreferencesPersistence;
import com.liferay.portal.kernel.service.persistence.PortletPersistence;
import com.liferay.portal.kernel.service.persistence.RoleFinder;
import com.liferay.portal.kernel.service.persistence.RolePersistence;
import com.liferay.portal.kernel.service.persistence.SystemEventPersistence;
import com.liferay.portal.kernel.service.persistence.UserFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupFinder;
import com.liferay.portal.kernel.service.persistence.UserGroupPersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.service.persistence.VirtualHostPersistence;
import com.liferay.portal.kernel.util.PortalUtil;

import java.lang.reflect.Field;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the company remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.portal.service.impl.CompanyServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.portal.service.impl.CompanyServiceImpl
 * @generated
 */
public abstract class CompanyServiceBaseImpl
	extends BaseServiceImpl implements CompanyService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>CompanyService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>CompanyServiceUtil</code>.
	 */

	/**
	 * Returns the company local service.
	 *
	 * @return the company local service
	 */
	public com.liferay.portal.kernel.service.CompanyLocalService
		getCompanyLocalService() {

		return companyLocalService;
	}

	/**
	 * Sets the company local service.
	 *
	 * @param companyLocalService the company local service
	 */
	public void setCompanyLocalService(
		com.liferay.portal.kernel.service.CompanyLocalService
			companyLocalService) {

		this.companyLocalService = companyLocalService;
	}

	/**
	 * Returns the company remote service.
	 *
	 * @return the company remote service
	 */
	public CompanyService getCompanyService() {
		return companyService;
	}

	/**
	 * Sets the company remote service.
	 *
	 * @param companyService the company remote service
	 */
	public void setCompanyService(CompanyService companyService) {
		this.companyService = companyService;
	}

	/**
	 * Returns the company persistence.
	 *
	 * @return the company persistence
	 */
	public CompanyPersistence getCompanyPersistence() {
		return companyPersistence;
	}

	/**
	 * Sets the company persistence.
	 *
	 * @param companyPersistence the company persistence
	 */
	public void setCompanyPersistence(CompanyPersistence companyPersistence) {
		this.companyPersistence = companyPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the account local service.
	 *
	 * @return the account local service
	 */
	public com.liferay.portal.kernel.service.AccountLocalService
		getAccountLocalService() {

		return accountLocalService;
	}

	/**
	 * Sets the account local service.
	 *
	 * @param accountLocalService the account local service
	 */
	public void setAccountLocalService(
		com.liferay.portal.kernel.service.AccountLocalService
			accountLocalService) {

		this.accountLocalService = accountLocalService;
	}

	/**
	 * Returns the account remote service.
	 *
	 * @return the account remote service
	 */
	public com.liferay.portal.kernel.service.AccountService
		getAccountService() {

		return accountService;
	}

	/**
	 * Sets the account remote service.
	 *
	 * @param accountService the account remote service
	 */
	public void setAccountService(
		com.liferay.portal.kernel.service.AccountService accountService) {

		this.accountService = accountService;
	}

	/**
	 * Returns the account persistence.
	 *
	 * @return the account persistence
	 */
	public AccountPersistence getAccountPersistence() {
		return accountPersistence;
	}

	/**
	 * Sets the account persistence.
	 *
	 * @param accountPersistence the account persistence
	 */
	public void setAccountPersistence(AccountPersistence accountPersistence) {
		this.accountPersistence = accountPersistence;
	}

	/**
	 * Returns the document library file entry type local service.
	 *
	 * @return the document library file entry type local service
	 */
	public
		com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService
			getDLFileEntryTypeLocalService() {

		return dlFileEntryTypeLocalService;
	}

	/**
	 * Sets the document library file entry type local service.
	 *
	 * @param dlFileEntryTypeLocalService the document library file entry type local service
	 */
	public void setDLFileEntryTypeLocalService(
		com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService
			dlFileEntryTypeLocalService) {

		this.dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
	}

	/**
	 * Returns the document library file entry type remote service.
	 *
	 * @return the document library file entry type remote service
	 */
	public com.liferay.document.library.kernel.service.DLFileEntryTypeService
		getDLFileEntryTypeService() {

		return dlFileEntryTypeService;
	}

	/**
	 * Sets the document library file entry type remote service.
	 *
	 * @param dlFileEntryTypeService the document library file entry type remote service
	 */
	public void setDLFileEntryTypeService(
		com.liferay.document.library.kernel.service.DLFileEntryTypeService
			dlFileEntryTypeService) {

		this.dlFileEntryTypeService = dlFileEntryTypeService;
	}

	/**
	 * Returns the document library file entry type persistence.
	 *
	 * @return the document library file entry type persistence
	 */
	public DLFileEntryTypePersistence getDLFileEntryTypePersistence() {
		return dlFileEntryTypePersistence;
	}

	/**
	 * Sets the document library file entry type persistence.
	 *
	 * @param dlFileEntryTypePersistence the document library file entry type persistence
	 */
	public void setDLFileEntryTypePersistence(
		DLFileEntryTypePersistence dlFileEntryTypePersistence) {

		this.dlFileEntryTypePersistence = dlFileEntryTypePersistence;
	}

	/**
	 * Returns the document library file entry type finder.
	 *
	 * @return the document library file entry type finder
	 */
	public DLFileEntryTypeFinder getDLFileEntryTypeFinder() {
		return dlFileEntryTypeFinder;
	}

	/**
	 * Sets the document library file entry type finder.
	 *
	 * @param dlFileEntryTypeFinder the document library file entry type finder
	 */
	public void setDLFileEntryTypeFinder(
		DLFileEntryTypeFinder dlFileEntryTypeFinder) {

		this.dlFileEntryTypeFinder = dlFileEntryTypeFinder;
	}

	/**
	 * Returns the expando column local service.
	 *
	 * @return the expando column local service
	 */
	public com.liferay.expando.kernel.service.ExpandoColumnLocalService
		getExpandoColumnLocalService() {

		return expandoColumnLocalService;
	}

	/**
	 * Sets the expando column local service.
	 *
	 * @param expandoColumnLocalService the expando column local service
	 */
	public void setExpandoColumnLocalService(
		com.liferay.expando.kernel.service.ExpandoColumnLocalService
			expandoColumnLocalService) {

		this.expandoColumnLocalService = expandoColumnLocalService;
	}

	/**
	 * Returns the expando column remote service.
	 *
	 * @return the expando column remote service
	 */
	public com.liferay.expando.kernel.service.ExpandoColumnService
		getExpandoColumnService() {

		return expandoColumnService;
	}

	/**
	 * Sets the expando column remote service.
	 *
	 * @param expandoColumnService the expando column remote service
	 */
	public void setExpandoColumnService(
		com.liferay.expando.kernel.service.ExpandoColumnService
			expandoColumnService) {

		this.expandoColumnService = expandoColumnService;
	}

	/**
	 * Returns the expando column persistence.
	 *
	 * @return the expando column persistence
	 */
	public ExpandoColumnPersistence getExpandoColumnPersistence() {
		return expandoColumnPersistence;
	}

	/**
	 * Sets the expando column persistence.
	 *
	 * @param expandoColumnPersistence the expando column persistence
	 */
	public void setExpandoColumnPersistence(
		ExpandoColumnPersistence expandoColumnPersistence) {

		this.expandoColumnPersistence = expandoColumnPersistence;
	}

	/**
	 * Returns the expando table local service.
	 *
	 * @return the expando table local service
	 */
	public com.liferay.expando.kernel.service.ExpandoTableLocalService
		getExpandoTableLocalService() {

		return expandoTableLocalService;
	}

	/**
	 * Sets the expando table local service.
	 *
	 * @param expandoTableLocalService the expando table local service
	 */
	public void setExpandoTableLocalService(
		com.liferay.expando.kernel.service.ExpandoTableLocalService
			expandoTableLocalService) {

		this.expandoTableLocalService = expandoTableLocalService;
	}

	/**
	 * Returns the expando table persistence.
	 *
	 * @return the expando table persistence
	 */
	public ExpandoTablePersistence getExpandoTablePersistence() {
		return expandoTablePersistence;
	}

	/**
	 * Sets the expando table persistence.
	 *
	 * @param expandoTablePersistence the expando table persistence
	 */
	public void setExpandoTablePersistence(
		ExpandoTablePersistence expandoTablePersistence) {

		this.expandoTablePersistence = expandoTablePersistence;
	}

	/**
	 * Returns the company info local service.
	 *
	 * @return the company info local service
	 */
	public com.liferay.portal.kernel.service.CompanyInfoLocalService
		getCompanyInfoLocalService() {

		return companyInfoLocalService;
	}

	/**
	 * Sets the company info local service.
	 *
	 * @param companyInfoLocalService the company info local service
	 */
	public void setCompanyInfoLocalService(
		com.liferay.portal.kernel.service.CompanyInfoLocalService
			companyInfoLocalService) {

		this.companyInfoLocalService = companyInfoLocalService;
	}

	/**
	 * Returns the company info persistence.
	 *
	 * @return the company info persistence
	 */
	public CompanyInfoPersistence getCompanyInfoPersistence() {
		return companyInfoPersistence;
	}

	/**
	 * Sets the company info persistence.
	 *
	 * @param companyInfoPersistence the company info persistence
	 */
	public void setCompanyInfoPersistence(
		CompanyInfoPersistence companyInfoPersistence) {

		this.companyInfoPersistence = companyInfoPersistence;
	}

	/**
	 * Returns the contact local service.
	 *
	 * @return the contact local service
	 */
	public com.liferay.portal.kernel.service.ContactLocalService
		getContactLocalService() {

		return contactLocalService;
	}

	/**
	 * Sets the contact local service.
	 *
	 * @param contactLocalService the contact local service
	 */
	public void setContactLocalService(
		com.liferay.portal.kernel.service.ContactLocalService
			contactLocalService) {

		this.contactLocalService = contactLocalService;
	}

	/**
	 * Returns the contact remote service.
	 *
	 * @return the contact remote service
	 */
	public com.liferay.portal.kernel.service.ContactService
		getContactService() {

		return contactService;
	}

	/**
	 * Sets the contact remote service.
	 *
	 * @param contactService the contact remote service
	 */
	public void setContactService(
		com.liferay.portal.kernel.service.ContactService contactService) {

		this.contactService = contactService;
	}

	/**
	 * Returns the contact persistence.
	 *
	 * @return the contact persistence
	 */
	public ContactPersistence getContactPersistence() {
		return contactPersistence;
	}

	/**
	 * Sets the contact persistence.
	 *
	 * @param contactPersistence the contact persistence
	 */
	public void setContactPersistence(ContactPersistence contactPersistence) {
		this.contactPersistence = contactPersistence;
	}

	/**
	 * Returns the group local service.
	 *
	 * @return the group local service
	 */
	public com.liferay.portal.kernel.service.GroupLocalService
		getGroupLocalService() {

		return groupLocalService;
	}

	/**
	 * Sets the group local service.
	 *
	 * @param groupLocalService the group local service
	 */
	public void setGroupLocalService(
		com.liferay.portal.kernel.service.GroupLocalService groupLocalService) {

		this.groupLocalService = groupLocalService;
	}

	/**
	 * Returns the group remote service.
	 *
	 * @return the group remote service
	 */
	public com.liferay.portal.kernel.service.GroupService getGroupService() {
		return groupService;
	}

	/**
	 * Sets the group remote service.
	 *
	 * @param groupService the group remote service
	 */
	public void setGroupService(
		com.liferay.portal.kernel.service.GroupService groupService) {

		this.groupService = groupService;
	}

	/**
	 * Returns the group persistence.
	 *
	 * @return the group persistence
	 */
	public GroupPersistence getGroupPersistence() {
		return groupPersistence;
	}

	/**
	 * Sets the group persistence.
	 *
	 * @param groupPersistence the group persistence
	 */
	public void setGroupPersistence(GroupPersistence groupPersistence) {
		this.groupPersistence = groupPersistence;
	}

	/**
	 * Returns the group finder.
	 *
	 * @return the group finder
	 */
	public GroupFinder getGroupFinder() {
		return groupFinder;
	}

	/**
	 * Sets the group finder.
	 *
	 * @param groupFinder the group finder
	 */
	public void setGroupFinder(GroupFinder groupFinder) {
		this.groupFinder = groupFinder;
	}

	/**
	 * Returns the image local service.
	 *
	 * @return the image local service
	 */
	public com.liferay.portal.kernel.service.ImageLocalService
		getImageLocalService() {

		return imageLocalService;
	}

	/**
	 * Sets the image local service.
	 *
	 * @param imageLocalService the image local service
	 */
	public void setImageLocalService(
		com.liferay.portal.kernel.service.ImageLocalService imageLocalService) {

		this.imageLocalService = imageLocalService;
	}

	/**
	 * Returns the image remote service.
	 *
	 * @return the image remote service
	 */
	public com.liferay.portal.kernel.service.ImageService getImageService() {
		return imageService;
	}

	/**
	 * Sets the image remote service.
	 *
	 * @param imageService the image remote service
	 */
	public void setImageService(
		com.liferay.portal.kernel.service.ImageService imageService) {

		this.imageService = imageService;
	}

	/**
	 * Returns the image persistence.
	 *
	 * @return the image persistence
	 */
	public ImagePersistence getImagePersistence() {
		return imagePersistence;
	}

	/**
	 * Sets the image persistence.
	 *
	 * @param imagePersistence the image persistence
	 */
	public void setImagePersistence(ImagePersistence imagePersistence) {
		this.imagePersistence = imagePersistence;
	}

	/**
	 * Returns the layout prototype local service.
	 *
	 * @return the layout prototype local service
	 */
	public com.liferay.portal.kernel.service.LayoutPrototypeLocalService
		getLayoutPrototypeLocalService() {

		return layoutPrototypeLocalService;
	}

	/**
	 * Sets the layout prototype local service.
	 *
	 * @param layoutPrototypeLocalService the layout prototype local service
	 */
	public void setLayoutPrototypeLocalService(
		com.liferay.portal.kernel.service.LayoutPrototypeLocalService
			layoutPrototypeLocalService) {

		this.layoutPrototypeLocalService = layoutPrototypeLocalService;
	}

	/**
	 * Returns the layout prototype remote service.
	 *
	 * @return the layout prototype remote service
	 */
	public com.liferay.portal.kernel.service.LayoutPrototypeService
		getLayoutPrototypeService() {

		return layoutPrototypeService;
	}

	/**
	 * Sets the layout prototype remote service.
	 *
	 * @param layoutPrototypeService the layout prototype remote service
	 */
	public void setLayoutPrototypeService(
		com.liferay.portal.kernel.service.LayoutPrototypeService
			layoutPrototypeService) {

		this.layoutPrototypeService = layoutPrototypeService;
	}

	/**
	 * Returns the layout prototype persistence.
	 *
	 * @return the layout prototype persistence
	 */
	public LayoutPrototypePersistence getLayoutPrototypePersistence() {
		return layoutPrototypePersistence;
	}

	/**
	 * Sets the layout prototype persistence.
	 *
	 * @param layoutPrototypePersistence the layout prototype persistence
	 */
	public void setLayoutPrototypePersistence(
		LayoutPrototypePersistence layoutPrototypePersistence) {

		this.layoutPrototypePersistence = layoutPrototypePersistence;
	}

	/**
	 * Returns the layout set prototype local service.
	 *
	 * @return the layout set prototype local service
	 */
	public com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService
		getLayoutSetPrototypeLocalService() {

		return layoutSetPrototypeLocalService;
	}

	/**
	 * Sets the layout set prototype local service.
	 *
	 * @param layoutSetPrototypeLocalService the layout set prototype local service
	 */
	public void setLayoutSetPrototypeLocalService(
		com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService
			layoutSetPrototypeLocalService) {

		this.layoutSetPrototypeLocalService = layoutSetPrototypeLocalService;
	}

	/**
	 * Returns the layout set prototype remote service.
	 *
	 * @return the layout set prototype remote service
	 */
	public com.liferay.portal.kernel.service.LayoutSetPrototypeService
		getLayoutSetPrototypeService() {

		return layoutSetPrototypeService;
	}

	/**
	 * Sets the layout set prototype remote service.
	 *
	 * @param layoutSetPrototypeService the layout set prototype remote service
	 */
	public void setLayoutSetPrototypeService(
		com.liferay.portal.kernel.service.LayoutSetPrototypeService
			layoutSetPrototypeService) {

		this.layoutSetPrototypeService = layoutSetPrototypeService;
	}

	/**
	 * Returns the layout set prototype persistence.
	 *
	 * @return the layout set prototype persistence
	 */
	public LayoutSetPrototypePersistence getLayoutSetPrototypePersistence() {
		return layoutSetPrototypePersistence;
	}

	/**
	 * Sets the layout set prototype persistence.
	 *
	 * @param layoutSetPrototypePersistence the layout set prototype persistence
	 */
	public void setLayoutSetPrototypePersistence(
		LayoutSetPrototypePersistence layoutSetPrototypePersistence) {

		this.layoutSetPrototypePersistence = layoutSetPrototypePersistence;
	}

	/**
	 * Returns the organization local service.
	 *
	 * @return the organization local service
	 */
	public com.liferay.portal.kernel.service.OrganizationLocalService
		getOrganizationLocalService() {

		return organizationLocalService;
	}

	/**
	 * Sets the organization local service.
	 *
	 * @param organizationLocalService the organization local service
	 */
	public void setOrganizationLocalService(
		com.liferay.portal.kernel.service.OrganizationLocalService
			organizationLocalService) {

		this.organizationLocalService = organizationLocalService;
	}

	/**
	 * Returns the organization remote service.
	 *
	 * @return the organization remote service
	 */
	public com.liferay.portal.kernel.service.OrganizationService
		getOrganizationService() {

		return organizationService;
	}

	/**
	 * Sets the organization remote service.
	 *
	 * @param organizationService the organization remote service
	 */
	public void setOrganizationService(
		com.liferay.portal.kernel.service.OrganizationService
			organizationService) {

		this.organizationService = organizationService;
	}

	/**
	 * Returns the organization persistence.
	 *
	 * @return the organization persistence
	 */
	public OrganizationPersistence getOrganizationPersistence() {
		return organizationPersistence;
	}

	/**
	 * Sets the organization persistence.
	 *
	 * @param organizationPersistence the organization persistence
	 */
	public void setOrganizationPersistence(
		OrganizationPersistence organizationPersistence) {

		this.organizationPersistence = organizationPersistence;
	}

	/**
	 * Returns the organization finder.
	 *
	 * @return the organization finder
	 */
	public OrganizationFinder getOrganizationFinder() {
		return organizationFinder;
	}

	/**
	 * Sets the organization finder.
	 *
	 * @param organizationFinder the organization finder
	 */
	public void setOrganizationFinder(OrganizationFinder organizationFinder) {
		this.organizationFinder = organizationFinder;
	}

	/**
	 * Returns the password policy local service.
	 *
	 * @return the password policy local service
	 */
	public com.liferay.portal.kernel.service.PasswordPolicyLocalService
		getPasswordPolicyLocalService() {

		return passwordPolicyLocalService;
	}

	/**
	 * Sets the password policy local service.
	 *
	 * @param passwordPolicyLocalService the password policy local service
	 */
	public void setPasswordPolicyLocalService(
		com.liferay.portal.kernel.service.PasswordPolicyLocalService
			passwordPolicyLocalService) {

		this.passwordPolicyLocalService = passwordPolicyLocalService;
	}

	/**
	 * Returns the password policy remote service.
	 *
	 * @return the password policy remote service
	 */
	public com.liferay.portal.kernel.service.PasswordPolicyService
		getPasswordPolicyService() {

		return passwordPolicyService;
	}

	/**
	 * Sets the password policy remote service.
	 *
	 * @param passwordPolicyService the password policy remote service
	 */
	public void setPasswordPolicyService(
		com.liferay.portal.kernel.service.PasswordPolicyService
			passwordPolicyService) {

		this.passwordPolicyService = passwordPolicyService;
	}

	/**
	 * Returns the password policy persistence.
	 *
	 * @return the password policy persistence
	 */
	public PasswordPolicyPersistence getPasswordPolicyPersistence() {
		return passwordPolicyPersistence;
	}

	/**
	 * Sets the password policy persistence.
	 *
	 * @param passwordPolicyPersistence the password policy persistence
	 */
	public void setPasswordPolicyPersistence(
		PasswordPolicyPersistence passwordPolicyPersistence) {

		this.passwordPolicyPersistence = passwordPolicyPersistence;
	}

	/**
	 * Returns the password policy finder.
	 *
	 * @return the password policy finder
	 */
	public PasswordPolicyFinder getPasswordPolicyFinder() {
		return passwordPolicyFinder;
	}

	/**
	 * Sets the password policy finder.
	 *
	 * @param passwordPolicyFinder the password policy finder
	 */
	public void setPasswordPolicyFinder(
		PasswordPolicyFinder passwordPolicyFinder) {

		this.passwordPolicyFinder = passwordPolicyFinder;
	}

	/**
	 * Returns the portal preferences local service.
	 *
	 * @return the portal preferences local service
	 */
	public com.liferay.portal.kernel.service.PortalPreferencesLocalService
		getPortalPreferencesLocalService() {

		return portalPreferencesLocalService;
	}

	/**
	 * Sets the portal preferences local service.
	 *
	 * @param portalPreferencesLocalService the portal preferences local service
	 */
	public void setPortalPreferencesLocalService(
		com.liferay.portal.kernel.service.PortalPreferencesLocalService
			portalPreferencesLocalService) {

		this.portalPreferencesLocalService = portalPreferencesLocalService;
	}

	/**
	 * Returns the portal preferences persistence.
	 *
	 * @return the portal preferences persistence
	 */
	public PortalPreferencesPersistence getPortalPreferencesPersistence() {
		return portalPreferencesPersistence;
	}

	/**
	 * Sets the portal preferences persistence.
	 *
	 * @param portalPreferencesPersistence the portal preferences persistence
	 */
	public void setPortalPreferencesPersistence(
		PortalPreferencesPersistence portalPreferencesPersistence) {

		this.portalPreferencesPersistence = portalPreferencesPersistence;
	}

	/**
	 * Returns the portlet local service.
	 *
	 * @return the portlet local service
	 */
	public com.liferay.portal.kernel.service.PortletLocalService
		getPortletLocalService() {

		return portletLocalService;
	}

	/**
	 * Sets the portlet local service.
	 *
	 * @param portletLocalService the portlet local service
	 */
	public void setPortletLocalService(
		com.liferay.portal.kernel.service.PortletLocalService
			portletLocalService) {

		this.portletLocalService = portletLocalService;
	}

	/**
	 * Returns the portlet remote service.
	 *
	 * @return the portlet remote service
	 */
	public com.liferay.portal.kernel.service.PortletService
		getPortletService() {

		return portletService;
	}

	/**
	 * Sets the portlet remote service.
	 *
	 * @param portletService the portlet remote service
	 */
	public void setPortletService(
		com.liferay.portal.kernel.service.PortletService portletService) {

		this.portletService = portletService;
	}

	/**
	 * Returns the portlet persistence.
	 *
	 * @return the portlet persistence
	 */
	public PortletPersistence getPortletPersistence() {
		return portletPersistence;
	}

	/**
	 * Sets the portlet persistence.
	 *
	 * @param portletPersistence the portlet persistence
	 */
	public void setPortletPersistence(PortletPersistence portletPersistence) {
		this.portletPersistence = portletPersistence;
	}

	/**
	 * Returns the role local service.
	 *
	 * @return the role local service
	 */
	public com.liferay.portal.kernel.service.RoleLocalService
		getRoleLocalService() {

		return roleLocalService;
	}

	/**
	 * Sets the role local service.
	 *
	 * @param roleLocalService the role local service
	 */
	public void setRoleLocalService(
		com.liferay.portal.kernel.service.RoleLocalService roleLocalService) {

		this.roleLocalService = roleLocalService;
	}

	/**
	 * Returns the role remote service.
	 *
	 * @return the role remote service
	 */
	public com.liferay.portal.kernel.service.RoleService getRoleService() {
		return roleService;
	}

	/**
	 * Sets the role remote service.
	 *
	 * @param roleService the role remote service
	 */
	public void setRoleService(
		com.liferay.portal.kernel.service.RoleService roleService) {

		this.roleService = roleService;
	}

	/**
	 * Returns the role persistence.
	 *
	 * @return the role persistence
	 */
	public RolePersistence getRolePersistence() {
		return rolePersistence;
	}

	/**
	 * Sets the role persistence.
	 *
	 * @param rolePersistence the role persistence
	 */
	public void setRolePersistence(RolePersistence rolePersistence) {
		this.rolePersistence = rolePersistence;
	}

	/**
	 * Returns the role finder.
	 *
	 * @return the role finder
	 */
	public RoleFinder getRoleFinder() {
		return roleFinder;
	}

	/**
	 * Sets the role finder.
	 *
	 * @param roleFinder the role finder
	 */
	public void setRoleFinder(RoleFinder roleFinder) {
		this.roleFinder = roleFinder;
	}

	/**
	 * Returns the system event local service.
	 *
	 * @return the system event local service
	 */
	public com.liferay.portal.kernel.service.SystemEventLocalService
		getSystemEventLocalService() {

		return systemEventLocalService;
	}

	/**
	 * Sets the system event local service.
	 *
	 * @param systemEventLocalService the system event local service
	 */
	public void setSystemEventLocalService(
		com.liferay.portal.kernel.service.SystemEventLocalService
			systemEventLocalService) {

		this.systemEventLocalService = systemEventLocalService;
	}

	/**
	 * Returns the system event persistence.
	 *
	 * @return the system event persistence
	 */
	public SystemEventPersistence getSystemEventPersistence() {
		return systemEventPersistence;
	}

	/**
	 * Sets the system event persistence.
	 *
	 * @param systemEventPersistence the system event persistence
	 */
	public void setSystemEventPersistence(
		SystemEventPersistence systemEventPersistence) {

		this.systemEventPersistence = systemEventPersistence;
	}

	/**
	 * Returns the user local service.
	 *
	 * @return the user local service
	 */
	public com.liferay.portal.kernel.service.UserLocalService
		getUserLocalService() {

		return userLocalService;
	}

	/**
	 * Sets the user local service.
	 *
	 * @param userLocalService the user local service
	 */
	public void setUserLocalService(
		com.liferay.portal.kernel.service.UserLocalService userLocalService) {

		this.userLocalService = userLocalService;
	}

	/**
	 * Returns the user remote service.
	 *
	 * @return the user remote service
	 */
	public com.liferay.portal.kernel.service.UserService getUserService() {
		return userService;
	}

	/**
	 * Sets the user remote service.
	 *
	 * @param userService the user remote service
	 */
	public void setUserService(
		com.liferay.portal.kernel.service.UserService userService) {

		this.userService = userService;
	}

	/**
	 * Returns the user persistence.
	 *
	 * @return the user persistence
	 */
	public UserPersistence getUserPersistence() {
		return userPersistence;
	}

	/**
	 * Sets the user persistence.
	 *
	 * @param userPersistence the user persistence
	 */
	public void setUserPersistence(UserPersistence userPersistence) {
		this.userPersistence = userPersistence;
	}

	/**
	 * Returns the user finder.
	 *
	 * @return the user finder
	 */
	public UserFinder getUserFinder() {
		return userFinder;
	}

	/**
	 * Sets the user finder.
	 *
	 * @param userFinder the user finder
	 */
	public void setUserFinder(UserFinder userFinder) {
		this.userFinder = userFinder;
	}

	/**
	 * Returns the user group local service.
	 *
	 * @return the user group local service
	 */
	public com.liferay.portal.kernel.service.UserGroupLocalService
		getUserGroupLocalService() {

		return userGroupLocalService;
	}

	/**
	 * Sets the user group local service.
	 *
	 * @param userGroupLocalService the user group local service
	 */
	public void setUserGroupLocalService(
		com.liferay.portal.kernel.service.UserGroupLocalService
			userGroupLocalService) {

		this.userGroupLocalService = userGroupLocalService;
	}

	/**
	 * Returns the user group remote service.
	 *
	 * @return the user group remote service
	 */
	public com.liferay.portal.kernel.service.UserGroupService
		getUserGroupService() {

		return userGroupService;
	}

	/**
	 * Sets the user group remote service.
	 *
	 * @param userGroupService the user group remote service
	 */
	public void setUserGroupService(
		com.liferay.portal.kernel.service.UserGroupService userGroupService) {

		this.userGroupService = userGroupService;
	}

	/**
	 * Returns the user group persistence.
	 *
	 * @return the user group persistence
	 */
	public UserGroupPersistence getUserGroupPersistence() {
		return userGroupPersistence;
	}

	/**
	 * Sets the user group persistence.
	 *
	 * @param userGroupPersistence the user group persistence
	 */
	public void setUserGroupPersistence(
		UserGroupPersistence userGroupPersistence) {

		this.userGroupPersistence = userGroupPersistence;
	}

	/**
	 * Returns the user group finder.
	 *
	 * @return the user group finder
	 */
	public UserGroupFinder getUserGroupFinder() {
		return userGroupFinder;
	}

	/**
	 * Sets the user group finder.
	 *
	 * @param userGroupFinder the user group finder
	 */
	public void setUserGroupFinder(UserGroupFinder userGroupFinder) {
		this.userGroupFinder = userGroupFinder;
	}

	/**
	 * Returns the virtual host local service.
	 *
	 * @return the virtual host local service
	 */
	public com.liferay.portal.kernel.service.VirtualHostLocalService
		getVirtualHostLocalService() {

		return virtualHostLocalService;
	}

	/**
	 * Sets the virtual host local service.
	 *
	 * @param virtualHostLocalService the virtual host local service
	 */
	public void setVirtualHostLocalService(
		com.liferay.portal.kernel.service.VirtualHostLocalService
			virtualHostLocalService) {

		this.virtualHostLocalService = virtualHostLocalService;
	}

	/**
	 * Returns the virtual host persistence.
	 *
	 * @return the virtual host persistence
	 */
	public VirtualHostPersistence getVirtualHostPersistence() {
		return virtualHostPersistence;
	}

	/**
	 * Sets the virtual host persistence.
	 *
	 * @param virtualHostPersistence the virtual host persistence
	 */
	public void setVirtualHostPersistence(
		VirtualHostPersistence virtualHostPersistence) {

		this.virtualHostPersistence = virtualHostPersistence;
	}

	public void afterPropertiesSet() {
		_setServiceUtilService(companyService);
	}

	public void destroy() {
		_setServiceUtilService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return CompanyService.class.getName();
	}

	protected Class<?> getModelClass() {
		return Company.class;
	}

	protected String getModelClassName() {
		return Company.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		try {
			DataSource dataSource = companyPersistence.getDataSource();

			DB db = DBManagerUtil.getDB();

			sql = db.buildSQL(sql);
			sql = PortalUtil.transformSQL(sql);

			SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(
				dataSource, sql);

			sqlUpdate.update();
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	private void _setServiceUtilService(CompanyService companyService) {
		try {
			Field field = CompanyServiceUtil.class.getDeclaredField("_service");

			field.setAccessible(true);

			field.set(null, companyService);
		}
		catch (ReflectiveOperationException reflectiveOperationException) {
			throw new RuntimeException(reflectiveOperationException);
		}
	}

	@BeanReference(
		type = com.liferay.portal.kernel.service.CompanyLocalService.class
	)
	protected com.liferay.portal.kernel.service.CompanyLocalService
		companyLocalService;

	@BeanReference(type = CompanyService.class)
	protected CompanyService companyService;

	@BeanReference(type = CompanyPersistence.class)
	protected CompanyPersistence companyPersistence;

	@BeanReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.AccountLocalService.class
	)
	protected com.liferay.portal.kernel.service.AccountLocalService
		accountLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.AccountService.class
	)
	protected com.liferay.portal.kernel.service.AccountService accountService;

	@BeanReference(type = AccountPersistence.class)
	protected AccountPersistence accountPersistence;

	@BeanReference(
		type = com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService.class
	)
	protected
		com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService
			dlFileEntryTypeLocalService;

	@BeanReference(
		type = com.liferay.document.library.kernel.service.DLFileEntryTypeService.class
	)
	protected com.liferay.document.library.kernel.service.DLFileEntryTypeService
		dlFileEntryTypeService;

	@BeanReference(type = DLFileEntryTypePersistence.class)
	protected DLFileEntryTypePersistence dlFileEntryTypePersistence;

	@BeanReference(type = DLFileEntryTypeFinder.class)
	protected DLFileEntryTypeFinder dlFileEntryTypeFinder;

	@BeanReference(
		type = com.liferay.expando.kernel.service.ExpandoColumnLocalService.class
	)
	protected com.liferay.expando.kernel.service.ExpandoColumnLocalService
		expandoColumnLocalService;

	@BeanReference(
		type = com.liferay.expando.kernel.service.ExpandoColumnService.class
	)
	protected com.liferay.expando.kernel.service.ExpandoColumnService
		expandoColumnService;

	@BeanReference(type = ExpandoColumnPersistence.class)
	protected ExpandoColumnPersistence expandoColumnPersistence;

	@BeanReference(
		type = com.liferay.expando.kernel.service.ExpandoTableLocalService.class
	)
	protected com.liferay.expando.kernel.service.ExpandoTableLocalService
		expandoTableLocalService;

	@BeanReference(type = ExpandoTablePersistence.class)
	protected ExpandoTablePersistence expandoTablePersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.CompanyInfoLocalService.class
	)
	protected com.liferay.portal.kernel.service.CompanyInfoLocalService
		companyInfoLocalService;

	@BeanReference(type = CompanyInfoPersistence.class)
	protected CompanyInfoPersistence companyInfoPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.ContactLocalService.class
	)
	protected com.liferay.portal.kernel.service.ContactLocalService
		contactLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.ContactService.class
	)
	protected com.liferay.portal.kernel.service.ContactService contactService;

	@BeanReference(type = ContactPersistence.class)
	protected ContactPersistence contactPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.GroupLocalService.class
	)
	protected com.liferay.portal.kernel.service.GroupLocalService
		groupLocalService;

	@BeanReference(type = com.liferay.portal.kernel.service.GroupService.class)
	protected com.liferay.portal.kernel.service.GroupService groupService;

	@BeanReference(type = GroupPersistence.class)
	protected GroupPersistence groupPersistence;

	@BeanReference(type = GroupFinder.class)
	protected GroupFinder groupFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.ImageLocalService.class
	)
	protected com.liferay.portal.kernel.service.ImageLocalService
		imageLocalService;

	@BeanReference(type = com.liferay.portal.kernel.service.ImageService.class)
	protected com.liferay.portal.kernel.service.ImageService imageService;

	@BeanReference(type = ImagePersistence.class)
	protected ImagePersistence imagePersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutPrototypeLocalService.class
	)
	protected com.liferay.portal.kernel.service.LayoutPrototypeLocalService
		layoutPrototypeLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutPrototypeService.class
	)
	protected com.liferay.portal.kernel.service.LayoutPrototypeService
		layoutPrototypeService;

	@BeanReference(type = LayoutPrototypePersistence.class)
	protected LayoutPrototypePersistence layoutPrototypePersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService.class
	)
	protected com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService
		layoutSetPrototypeLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.LayoutSetPrototypeService.class
	)
	protected com.liferay.portal.kernel.service.LayoutSetPrototypeService
		layoutSetPrototypeService;

	@BeanReference(type = LayoutSetPrototypePersistence.class)
	protected LayoutSetPrototypePersistence layoutSetPrototypePersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.OrganizationLocalService.class
	)
	protected com.liferay.portal.kernel.service.OrganizationLocalService
		organizationLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.OrganizationService.class
	)
	protected com.liferay.portal.kernel.service.OrganizationService
		organizationService;

	@BeanReference(type = OrganizationPersistence.class)
	protected OrganizationPersistence organizationPersistence;

	@BeanReference(type = OrganizationFinder.class)
	protected OrganizationFinder organizationFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PasswordPolicyLocalService.class
	)
	protected com.liferay.portal.kernel.service.PasswordPolicyLocalService
		passwordPolicyLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PasswordPolicyService.class
	)
	protected com.liferay.portal.kernel.service.PasswordPolicyService
		passwordPolicyService;

	@BeanReference(type = PasswordPolicyPersistence.class)
	protected PasswordPolicyPersistence passwordPolicyPersistence;

	@BeanReference(type = PasswordPolicyFinder.class)
	protected PasswordPolicyFinder passwordPolicyFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PortalPreferencesLocalService.class
	)
	protected com.liferay.portal.kernel.service.PortalPreferencesLocalService
		portalPreferencesLocalService;

	@BeanReference(type = PortalPreferencesPersistence.class)
	protected PortalPreferencesPersistence portalPreferencesPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PortletLocalService.class
	)
	protected com.liferay.portal.kernel.service.PortletLocalService
		portletLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.PortletService.class
	)
	protected com.liferay.portal.kernel.service.PortletService portletService;

	@BeanReference(type = PortletPersistence.class)
	protected PortletPersistence portletPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.RoleLocalService.class
	)
	protected com.liferay.portal.kernel.service.RoleLocalService
		roleLocalService;

	@BeanReference(type = com.liferay.portal.kernel.service.RoleService.class)
	protected com.liferay.portal.kernel.service.RoleService roleService;

	@BeanReference(type = RolePersistence.class)
	protected RolePersistence rolePersistence;

	@BeanReference(type = RoleFinder.class)
	protected RoleFinder roleFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.SystemEventLocalService.class
	)
	protected com.liferay.portal.kernel.service.SystemEventLocalService
		systemEventLocalService;

	@BeanReference(type = SystemEventPersistence.class)
	protected SystemEventPersistence systemEventPersistence;

	@BeanReference(
		type = com.liferay.portal.kernel.service.UserLocalService.class
	)
	protected com.liferay.portal.kernel.service.UserLocalService
		userLocalService;

	@BeanReference(type = com.liferay.portal.kernel.service.UserService.class)
	protected com.liferay.portal.kernel.service.UserService userService;

	@BeanReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;

	@BeanReference(type = UserFinder.class)
	protected UserFinder userFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.UserGroupLocalService.class
	)
	protected com.liferay.portal.kernel.service.UserGroupLocalService
		userGroupLocalService;

	@BeanReference(
		type = com.liferay.portal.kernel.service.UserGroupService.class
	)
	protected com.liferay.portal.kernel.service.UserGroupService
		userGroupService;

	@BeanReference(type = UserGroupPersistence.class)
	protected UserGroupPersistence userGroupPersistence;

	@BeanReference(type = UserGroupFinder.class)
	protected UserGroupFinder userGroupFinder;

	@BeanReference(
		type = com.liferay.portal.kernel.service.VirtualHostLocalService.class
	)
	protected com.liferay.portal.kernel.service.VirtualHostLocalService
		virtualHostLocalService;

	@BeanReference(type = VirtualHostPersistence.class)
	protected VirtualHostPersistence virtualHostPersistence;

}