/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryModel;
import com.liferay.asset.kernel.model.AssetEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the AssetEntry service. Represents a row in the &quot;AssetEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AssetEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AssetEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetEntryImpl
 * @generated
 */
@JSON(strict = true)
public class AssetEntryModelImpl
	extends BaseModelImpl<AssetEntry> implements AssetEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a asset entry model instance should use the <code>AssetEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "AssetEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"entryId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"classUuid", Types.VARCHAR},
		{"classTypeId", Types.BIGINT}, {"listable", Types.BOOLEAN},
		{"visible", Types.BOOLEAN}, {"startDate", Types.TIMESTAMP},
		{"endDate", Types.TIMESTAMP}, {"publishDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP}, {"mimeType", Types.VARCHAR},
		{"title", Types.CLOB}, {"description", Types.CLOB},
		{"summary", Types.CLOB}, {"url", Types.VARCHAR},
		{"layoutUuid", Types.VARCHAR}, {"height", Types.INTEGER},
		{"width", Types.INTEGER}, {"priority", Types.DOUBLE}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("entryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("classTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("listable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("visible", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("startDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("endDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("publishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.CLOB);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("summary", Types.CLOB);
		TABLE_COLUMNS_MAP.put("url", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("height", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("width", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE =
		"create table AssetEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,entryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,classUuid VARCHAR(75) null,classTypeId LONG,listable BOOLEAN,visible BOOLEAN,startDate DATE null,endDate DATE null,publishDate DATE null,expirationDate DATE null,mimeType VARCHAR(75) null,title TEXT null,description TEXT null,summary TEXT null,url STRING null,layoutUuid VARCHAR(75) null,height INTEGER,width INTEGER,priority DOUBLE,primary key (entryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table AssetEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY assetEntry.entryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY AssetEntry.entryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSUUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTUUID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PUBLISHDATE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VISIBLE_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ENTRYID_COLUMN_BITMASK = 512L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static AssetEntry toModel(AssetEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		AssetEntry model = new AssetEntryImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setEntryId(soapModel.getEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setClassUuid(soapModel.getClassUuid());
		model.setClassTypeId(soapModel.getClassTypeId());
		model.setListable(soapModel.isListable());
		model.setVisible(soapModel.isVisible());
		model.setStartDate(soapModel.getStartDate());
		model.setEndDate(soapModel.getEndDate());
		model.setPublishDate(soapModel.getPublishDate());
		model.setExpirationDate(soapModel.getExpirationDate());
		model.setMimeType(soapModel.getMimeType());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setSummary(soapModel.getSummary());
		model.setUrl(soapModel.getUrl());
		model.setLayoutUuid(soapModel.getLayoutUuid());
		model.setHeight(soapModel.getHeight());
		model.setWidth(soapModel.getWidth());
		model.setPriority(soapModel.getPriority());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<AssetEntry> toModels(AssetEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<AssetEntry> models = new ArrayList<AssetEntry>(soapModels.length);

		for (AssetEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_NAME =
		"AssetEntries_AssetTags";

	public static final Object[][]
		MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_COLUMNS = {
			{"companyId", Types.BIGINT}, {"entryId", Types.BIGINT},
			{"tagId", Types.BIGINT}
		};

	public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_SQL_CREATE =
		"create table AssetEntries_AssetTags (companyId LONG not null,entryId LONG not null,tagId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (entryId, tagId, ctCollectionId))";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETTAGS =
		true;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.asset.kernel.model.AssetEntry"));

	public AssetEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _entryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _entryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AssetEntry.class;
	}

	@Override
	public String getModelClassName() {
		return AssetEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<AssetEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<AssetEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AssetEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((AssetEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<AssetEntry, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<AssetEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(AssetEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<AssetEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<AssetEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, AssetEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			AssetEntry.class.getClassLoader(), AssetEntry.class,
			ModelWrapper.class);

		try {
			Constructor<AssetEntry> constructor =
				(Constructor<AssetEntry>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<AssetEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<AssetEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<AssetEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<AssetEntry, Object>>();
		Map<String, BiConsumer<AssetEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<AssetEntry, ?>>();

		attributeGetterFunctions.put("mvccVersion", AssetEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<AssetEntry, Long>)AssetEntry::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", AssetEntry::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<AssetEntry, Long>)AssetEntry::setCtCollectionId);
		attributeGetterFunctions.put("entryId", AssetEntry::getEntryId);
		attributeSetterBiConsumers.put(
			"entryId", (BiConsumer<AssetEntry, Long>)AssetEntry::setEntryId);
		attributeGetterFunctions.put("groupId", AssetEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<AssetEntry, Long>)AssetEntry::setGroupId);
		attributeGetterFunctions.put("companyId", AssetEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<AssetEntry, Long>)AssetEntry::setCompanyId);
		attributeGetterFunctions.put("userId", AssetEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<AssetEntry, Long>)AssetEntry::setUserId);
		attributeGetterFunctions.put("userName", AssetEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<AssetEntry, String>)AssetEntry::setUserName);
		attributeGetterFunctions.put("createDate", AssetEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<AssetEntry, Date>)AssetEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", AssetEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<AssetEntry, Date>)AssetEntry::setModifiedDate);
		attributeGetterFunctions.put("classNameId", AssetEntry::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<AssetEntry, Long>)AssetEntry::setClassNameId);
		attributeGetterFunctions.put("classPK", AssetEntry::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK", (BiConsumer<AssetEntry, Long>)AssetEntry::setClassPK);
		attributeGetterFunctions.put("classUuid", AssetEntry::getClassUuid);
		attributeSetterBiConsumers.put(
			"classUuid",
			(BiConsumer<AssetEntry, String>)AssetEntry::setClassUuid);
		attributeGetterFunctions.put("classTypeId", AssetEntry::getClassTypeId);
		attributeSetterBiConsumers.put(
			"classTypeId",
			(BiConsumer<AssetEntry, Long>)AssetEntry::setClassTypeId);
		attributeGetterFunctions.put("listable", AssetEntry::getListable);
		attributeSetterBiConsumers.put(
			"listable",
			(BiConsumer<AssetEntry, Boolean>)AssetEntry::setListable);
		attributeGetterFunctions.put("visible", AssetEntry::getVisible);
		attributeSetterBiConsumers.put(
			"visible", (BiConsumer<AssetEntry, Boolean>)AssetEntry::setVisible);
		attributeGetterFunctions.put("startDate", AssetEntry::getStartDate);
		attributeSetterBiConsumers.put(
			"startDate",
			(BiConsumer<AssetEntry, Date>)AssetEntry::setStartDate);
		attributeGetterFunctions.put("endDate", AssetEntry::getEndDate);
		attributeSetterBiConsumers.put(
			"endDate", (BiConsumer<AssetEntry, Date>)AssetEntry::setEndDate);
		attributeGetterFunctions.put("publishDate", AssetEntry::getPublishDate);
		attributeSetterBiConsumers.put(
			"publishDate",
			(BiConsumer<AssetEntry, Date>)AssetEntry::setPublishDate);
		attributeGetterFunctions.put(
			"expirationDate", AssetEntry::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<AssetEntry, Date>)AssetEntry::setExpirationDate);
		attributeGetterFunctions.put("mimeType", AssetEntry::getMimeType);
		attributeSetterBiConsumers.put(
			"mimeType",
			(BiConsumer<AssetEntry, String>)AssetEntry::setMimeType);
		attributeGetterFunctions.put("title", AssetEntry::getTitle);
		attributeSetterBiConsumers.put(
			"title", (BiConsumer<AssetEntry, String>)AssetEntry::setTitle);
		attributeGetterFunctions.put("description", AssetEntry::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<AssetEntry, String>)AssetEntry::setDescription);
		attributeGetterFunctions.put("summary", AssetEntry::getSummary);
		attributeSetterBiConsumers.put(
			"summary", (BiConsumer<AssetEntry, String>)AssetEntry::setSummary);
		attributeGetterFunctions.put("url", AssetEntry::getUrl);
		attributeSetterBiConsumers.put(
			"url", (BiConsumer<AssetEntry, String>)AssetEntry::setUrl);
		attributeGetterFunctions.put("layoutUuid", AssetEntry::getLayoutUuid);
		attributeSetterBiConsumers.put(
			"layoutUuid",
			(BiConsumer<AssetEntry, String>)AssetEntry::setLayoutUuid);
		attributeGetterFunctions.put("height", AssetEntry::getHeight);
		attributeSetterBiConsumers.put(
			"height", (BiConsumer<AssetEntry, Integer>)AssetEntry::setHeight);
		attributeGetterFunctions.put("width", AssetEntry::getWidth);
		attributeSetterBiConsumers.put(
			"width", (BiConsumer<AssetEntry, Integer>)AssetEntry::setWidth);
		attributeGetterFunctions.put("priority", AssetEntry::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<AssetEntry, Double>)AssetEntry::setPriority);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public long getEntryId() {
		return _entryId;
	}

	@Override
	public void setEntryId(long entryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_entryId = entryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public String getClassUuid() {
		if (_classUuid == null) {
			return "";
		}
		else {
			return _classUuid;
		}
	}

	@Override
	public void setClassUuid(String classUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classUuid = classUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalClassUuid() {
		return getColumnOriginalValue("classUuid");
	}

	@JSON
	@Override
	public long getClassTypeId() {
		return _classTypeId;
	}

	@Override
	public void setClassTypeId(long classTypeId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classTypeId = classTypeId;
	}

	@JSON
	@Override
	public boolean getListable() {
		return _listable;
	}

	@JSON
	@Override
	public boolean isListable() {
		return _listable;
	}

	@Override
	public void setListable(boolean listable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_listable = listable;
	}

	@JSON
	@Override
	public boolean getVisible() {
		return _visible;
	}

	@JSON
	@Override
	public boolean isVisible() {
		return _visible;
	}

	@Override
	public void setVisible(boolean visible) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_visible = visible;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalVisible() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("visible"));
	}

	@JSON
	@Override
	public Date getStartDate() {
		return _startDate;
	}

	@Override
	public void setStartDate(Date startDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_startDate = startDate;
	}

	@JSON
	@Override
	public Date getEndDate() {
		return _endDate;
	}

	@Override
	public void setEndDate(Date endDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_endDate = endDate;
	}

	@JSON
	@Override
	public Date getPublishDate() {
		return _publishDate;
	}

	@Override
	public void setPublishDate(Date publishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_publishDate = publishDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalPublishDate() {
		return getColumnOriginalValue("publishDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return "";
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mimeType = mimeType;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}

	@Override
	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}

	@Override
	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}

	@Override
	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTitle(), languageId, useDefault);
	}

	@Override
	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON
	@Override
	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}

	@Override
	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@Override
	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(
				LocalizationUtil.updateLocalization(
					getTitle(), "Title", title, languageId, defaultLanguageId));
		}
		else {
			setTitle(
				LocalizationUtil.removeLocalization(
					getTitle(), "Title", languageId));
		}
	}

	@Override
	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}

	@Override
	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setTitleMap(
		Map<Locale, String> titleMap, Locale defaultLocale) {

		if (titleMap == null) {
			return;
		}

		setTitle(
			LocalizationUtil.updateLocalization(
				titleMap, getTitle(), "Title",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}

	@Override
	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}

	@Override
	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}

	@Override
	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getDescription(), languageId, useDefault);
	}

	@Override
	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON
	@Override
	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}

	@Override
	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescription(
		String description, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(
				LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(
				LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}

	@Override
	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}

	@Override
	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setDescriptionMap(
		Map<Locale, String> descriptionMap, Locale defaultLocale) {

		if (descriptionMap == null) {
			return;
		}

		setDescription(
			LocalizationUtil.updateLocalization(
				descriptionMap, getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSummary() {
		if (_summary == null) {
			return "";
		}
		else {
			return _summary;
		}
	}

	@Override
	public String getSummary(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSummary(languageId);
	}

	@Override
	public String getSummary(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSummary(languageId, useDefault);
	}

	@Override
	public String getSummary(String languageId) {
		return LocalizationUtil.getLocalization(getSummary(), languageId);
	}

	@Override
	public String getSummary(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getSummary(), languageId, useDefault);
	}

	@Override
	public String getSummaryCurrentLanguageId() {
		return _summaryCurrentLanguageId;
	}

	@JSON
	@Override
	public String getSummaryCurrentValue() {
		Locale locale = getLocale(_summaryCurrentLanguageId);

		return getSummary(locale);
	}

	@Override
	public Map<Locale, String> getSummaryMap() {
		return LocalizationUtil.getLocalizationMap(getSummary());
	}

	@Override
	public void setSummary(String summary) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_summary = summary;
	}

	@Override
	public void setSummary(String summary, Locale locale) {
		setSummary(summary, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSummary(
		String summary, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(summary)) {
			setSummary(
				LocalizationUtil.updateLocalization(
					getSummary(), "Summary", summary, languageId,
					defaultLanguageId));
		}
		else {
			setSummary(
				LocalizationUtil.removeLocalization(
					getSummary(), "Summary", languageId));
		}
	}

	@Override
	public void setSummaryCurrentLanguageId(String languageId) {
		_summaryCurrentLanguageId = languageId;
	}

	@Override
	public void setSummaryMap(Map<Locale, String> summaryMap) {
		setSummaryMap(summaryMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSummaryMap(
		Map<Locale, String> summaryMap, Locale defaultLocale) {

		if (summaryMap == null) {
			return;
		}

		setSummary(
			LocalizationUtil.updateLocalization(
				summaryMap, getSummary(), "Summary",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getUrl() {
		if (_url == null) {
			return "";
		}
		else {
			return _url;
		}
	}

	@Override
	public void setUrl(String url) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_url = url;
	}

	@JSON
	@Override
	public String getLayoutUuid() {
		if (_layoutUuid == null) {
			return "";
		}
		else {
			return _layoutUuid;
		}
	}

	@Override
	public void setLayoutUuid(String layoutUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutUuid = layoutUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLayoutUuid() {
		return getColumnOriginalValue("layoutUuid");
	}

	@JSON
	@Override
	public int getHeight() {
		return _height;
	}

	@Override
	public void setHeight(int height) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_height = height;
	}

	@JSON
	@Override
	public int getWidth() {
		return _width;
	}

	@Override
	public void setWidth(int width) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_width = width;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), AssetEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> summaryMap = getSummaryMap();

		for (Map.Entry<Locale, String> entry : summaryMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getTitle();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			AssetEntry.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(
				getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(
				getDescription(defaultLocale), defaultLocale, defaultLocale);
		}

		String summary = getSummary(defaultLocale);

		if (Validator.isNull(summary)) {
			setSummary(getSummary(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setSummary(getSummary(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public AssetEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, AssetEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AssetEntryImpl assetEntryImpl = new AssetEntryImpl();

		assetEntryImpl.setMvccVersion(getMvccVersion());
		assetEntryImpl.setCtCollectionId(getCtCollectionId());
		assetEntryImpl.setEntryId(getEntryId());
		assetEntryImpl.setGroupId(getGroupId());
		assetEntryImpl.setCompanyId(getCompanyId());
		assetEntryImpl.setUserId(getUserId());
		assetEntryImpl.setUserName(getUserName());
		assetEntryImpl.setCreateDate(getCreateDate());
		assetEntryImpl.setModifiedDate(getModifiedDate());
		assetEntryImpl.setClassNameId(getClassNameId());
		assetEntryImpl.setClassPK(getClassPK());
		assetEntryImpl.setClassUuid(getClassUuid());
		assetEntryImpl.setClassTypeId(getClassTypeId());
		assetEntryImpl.setListable(isListable());
		assetEntryImpl.setVisible(isVisible());
		assetEntryImpl.setStartDate(getStartDate());
		assetEntryImpl.setEndDate(getEndDate());
		assetEntryImpl.setPublishDate(getPublishDate());
		assetEntryImpl.setExpirationDate(getExpirationDate());
		assetEntryImpl.setMimeType(getMimeType());
		assetEntryImpl.setTitle(getTitle());
		assetEntryImpl.setDescription(getDescription());
		assetEntryImpl.setSummary(getSummary());
		assetEntryImpl.setUrl(getUrl());
		assetEntryImpl.setLayoutUuid(getLayoutUuid());
		assetEntryImpl.setHeight(getHeight());
		assetEntryImpl.setWidth(getWidth());
		assetEntryImpl.setPriority(getPriority());

		assetEntryImpl.resetOriginalValues();

		return assetEntryImpl;
	}

	@Override
	public int compareTo(AssetEntry assetEntry) {
		long primaryKey = assetEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof AssetEntry)) {
			return false;
		}

		AssetEntry assetEntry = (AssetEntry)object;

		long primaryKey = assetEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<AssetEntry> toCacheModel() {
		AssetEntryCacheModel assetEntryCacheModel = new AssetEntryCacheModel();

		assetEntryCacheModel.mvccVersion = getMvccVersion();

		assetEntryCacheModel.ctCollectionId = getCtCollectionId();

		assetEntryCacheModel.entryId = getEntryId();

		assetEntryCacheModel.groupId = getGroupId();

		assetEntryCacheModel.companyId = getCompanyId();

		assetEntryCacheModel.userId = getUserId();

		assetEntryCacheModel.userName = getUserName();

		String userName = assetEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			assetEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			assetEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			assetEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			assetEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			assetEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		assetEntryCacheModel.classNameId = getClassNameId();

		assetEntryCacheModel.classPK = getClassPK();

		assetEntryCacheModel.classUuid = getClassUuid();

		String classUuid = assetEntryCacheModel.classUuid;

		if ((classUuid != null) && (classUuid.length() == 0)) {
			assetEntryCacheModel.classUuid = null;
		}

		assetEntryCacheModel.classTypeId = getClassTypeId();

		assetEntryCacheModel.listable = isListable();

		assetEntryCacheModel.visible = isVisible();

		Date startDate = getStartDate();

		if (startDate != null) {
			assetEntryCacheModel.startDate = startDate.getTime();
		}
		else {
			assetEntryCacheModel.startDate = Long.MIN_VALUE;
		}

		Date endDate = getEndDate();

		if (endDate != null) {
			assetEntryCacheModel.endDate = endDate.getTime();
		}
		else {
			assetEntryCacheModel.endDate = Long.MIN_VALUE;
		}

		Date publishDate = getPublishDate();

		if (publishDate != null) {
			assetEntryCacheModel.publishDate = publishDate.getTime();
		}
		else {
			assetEntryCacheModel.publishDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			assetEntryCacheModel.expirationDate = expirationDate.getTime();
		}
		else {
			assetEntryCacheModel.expirationDate = Long.MIN_VALUE;
		}

		assetEntryCacheModel.mimeType = getMimeType();

		String mimeType = assetEntryCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			assetEntryCacheModel.mimeType = null;
		}

		assetEntryCacheModel.title = getTitle();

		String title = assetEntryCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			assetEntryCacheModel.title = null;
		}

		assetEntryCacheModel.description = getDescription();

		String description = assetEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			assetEntryCacheModel.description = null;
		}

		assetEntryCacheModel.summary = getSummary();

		String summary = assetEntryCacheModel.summary;

		if ((summary != null) && (summary.length() == 0)) {
			assetEntryCacheModel.summary = null;
		}

		assetEntryCacheModel.url = getUrl();

		String url = assetEntryCacheModel.url;

		if ((url != null) && (url.length() == 0)) {
			assetEntryCacheModel.url = null;
		}

		assetEntryCacheModel.layoutUuid = getLayoutUuid();

		String layoutUuid = assetEntryCacheModel.layoutUuid;

		if ((layoutUuid != null) && (layoutUuid.length() == 0)) {
			assetEntryCacheModel.layoutUuid = null;
		}

		assetEntryCacheModel.height = getHeight();

		assetEntryCacheModel.width = getWidth();

		assetEntryCacheModel.priority = getPriority();

		return assetEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<AssetEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(4 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<AssetEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AssetEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((AssetEntry)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<AssetEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<AssetEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AssetEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((AssetEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, AssetEntry>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _entryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private String _classUuid;
	private long _classTypeId;
	private boolean _listable;
	private boolean _visible;
	private Date _startDate;
	private Date _endDate;
	private Date _publishDate;
	private Date _expirationDate;
	private String _mimeType;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _summary;
	private String _summaryCurrentLanguageId;
	private String _url;
	private String _layoutUuid;
	private int _height;
	private int _width;
	private double _priority;

	public <T> T getColumnValue(String columnName) {
		Function<AssetEntry, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((AssetEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("entryId", _entryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("classUuid", _classUuid);
		_columnOriginalValues.put("classTypeId", _classTypeId);
		_columnOriginalValues.put("listable", _listable);
		_columnOriginalValues.put("visible", _visible);
		_columnOriginalValues.put("startDate", _startDate);
		_columnOriginalValues.put("endDate", _endDate);
		_columnOriginalValues.put("publishDate", _publishDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("mimeType", _mimeType);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("summary", _summary);
		_columnOriginalValues.put("url", _url);
		_columnOriginalValues.put("layoutUuid", _layoutUuid);
		_columnOriginalValues.put("height", _height);
		_columnOriginalValues.put("width", _width);
		_columnOriginalValues.put("priority", _priority);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("entryId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("classNameId", 512L);

		columnBitmasks.put("classPK", 1024L);

		columnBitmasks.put("classUuid", 2048L);

		columnBitmasks.put("classTypeId", 4096L);

		columnBitmasks.put("listable", 8192L);

		columnBitmasks.put("visible", 16384L);

		columnBitmasks.put("startDate", 32768L);

		columnBitmasks.put("endDate", 65536L);

		columnBitmasks.put("publishDate", 131072L);

		columnBitmasks.put("expirationDate", 262144L);

		columnBitmasks.put("mimeType", 524288L);

		columnBitmasks.put("title", 1048576L);

		columnBitmasks.put("description", 2097152L);

		columnBitmasks.put("summary", 4194304L);

		columnBitmasks.put("url", 8388608L);

		columnBitmasks.put("layoutUuid", 16777216L);

		columnBitmasks.put("height", 33554432L);

		columnBitmasks.put("width", 67108864L);

		columnBitmasks.put("priority", 134217728L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private AssetEntry _escapedModel;

}