/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.redirect.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the RedirectEntry service. Represents a row in the &quot;RedirectEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.redirect.model.impl.RedirectEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.redirect.model.impl.RedirectEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RedirectEntry
 * @generated
 */
@ProviderType
public interface RedirectEntryModel
	extends BaseModel<RedirectEntry>, GroupedModel, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a redirect entry model instance should use the {@link RedirectEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this redirect entry.
	 *
	 * @return the primary key of this redirect entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this redirect entry.
	 *
	 * @param primaryKey the primary key of this redirect entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this redirect entry.
	 *
	 * @return the mvcc version of this redirect entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this redirect entry.
	 *
	 * @param mvccVersion the mvcc version of this redirect entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this redirect entry.
	 *
	 * @return the uuid of this redirect entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this redirect entry.
	 *
	 * @param uuid the uuid of this redirect entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the redirect entry ID of this redirect entry.
	 *
	 * @return the redirect entry ID of this redirect entry
	 */
	public long getRedirectEntryId();

	/**
	 * Sets the redirect entry ID of this redirect entry.
	 *
	 * @param redirectEntryId the redirect entry ID of this redirect entry
	 */
	public void setRedirectEntryId(long redirectEntryId);

	/**
	 * Returns the group ID of this redirect entry.
	 *
	 * @return the group ID of this redirect entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this redirect entry.
	 *
	 * @param groupId the group ID of this redirect entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this redirect entry.
	 *
	 * @return the company ID of this redirect entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this redirect entry.
	 *
	 * @param companyId the company ID of this redirect entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this redirect entry.
	 *
	 * @return the user ID of this redirect entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this redirect entry.
	 *
	 * @param userId the user ID of this redirect entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this redirect entry.
	 *
	 * @return the user uuid of this redirect entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this redirect entry.
	 *
	 * @param userUuid the user uuid of this redirect entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this redirect entry.
	 *
	 * @return the user name of this redirect entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this redirect entry.
	 *
	 * @param userName the user name of this redirect entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this redirect entry.
	 *
	 * @return the create date of this redirect entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this redirect entry.
	 *
	 * @param createDate the create date of this redirect entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this redirect entry.
	 *
	 * @return the modified date of this redirect entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this redirect entry.
	 *
	 * @param modifiedDate the modified date of this redirect entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the destination url of this redirect entry.
	 *
	 * @return the destination url of this redirect entry
	 */
	@AutoEscape
	public String getDestinationURL();

	/**
	 * Sets the destination url of this redirect entry.
	 *
	 * @param destinationURL the destination url of this redirect entry
	 */
	public void setDestinationURL(String destinationURL);

	/**
	 * Returns the expiration date of this redirect entry.
	 *
	 * @return the expiration date of this redirect entry
	 */
	public Date getExpirationDate();

	/**
	 * Sets the expiration date of this redirect entry.
	 *
	 * @param expirationDate the expiration date of this redirect entry
	 */
	public void setExpirationDate(Date expirationDate);

	/**
	 * Returns the last occurrence date of this redirect entry.
	 *
	 * @return the last occurrence date of this redirect entry
	 */
	public Date getLastOccurrenceDate();

	/**
	 * Sets the last occurrence date of this redirect entry.
	 *
	 * @param lastOccurrenceDate the last occurrence date of this redirect entry
	 */
	public void setLastOccurrenceDate(Date lastOccurrenceDate);

	/**
	 * Returns the permanent of this redirect entry.
	 *
	 * @return the permanent of this redirect entry
	 */
	public boolean getPermanent();

	/**
	 * Returns <code>true</code> if this redirect entry is permanent.
	 *
	 * @return <code>true</code> if this redirect entry is permanent; <code>false</code> otherwise
	 */
	public boolean isPermanent();

	/**
	 * Sets whether this redirect entry is permanent.
	 *
	 * @param permanent the permanent of this redirect entry
	 */
	public void setPermanent(boolean permanent);

	/**
	 * Returns the source url of this redirect entry.
	 *
	 * @return the source url of this redirect entry
	 */
	@AutoEscape
	public String getSourceURL();

	/**
	 * Sets the source url of this redirect entry.
	 *
	 * @param sourceURL the source url of this redirect entry
	 */
	public void setSourceURL(String sourceURL);

}