/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.analytics.message.storage.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AnalyticsDeleteMessage service. Represents a row in the &quot;AnalyticsDeleteMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.analytics.message.storage.model.impl.AnalyticsDeleteMessageModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.analytics.message.storage.model.impl.AnalyticsDeleteMessageImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AnalyticsDeleteMessage
 * @generated
 */
@ProviderType
public interface AnalyticsDeleteMessageModel
	extends BaseModel<AnalyticsDeleteMessage>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a analytics delete message model instance should use the {@link AnalyticsDeleteMessage} interface instead.
	 */

	/**
	 * Returns the primary key of this analytics delete message.
	 *
	 * @return the primary key of this analytics delete message
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this analytics delete message.
	 *
	 * @param primaryKey the primary key of this analytics delete message
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this analytics delete message.
	 *
	 * @return the mvcc version of this analytics delete message
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this analytics delete message.
	 *
	 * @param mvccVersion the mvcc version of this analytics delete message
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the analytics delete message ID of this analytics delete message.
	 *
	 * @return the analytics delete message ID of this analytics delete message
	 */
	public long getAnalyticsDeleteMessageId();

	/**
	 * Sets the analytics delete message ID of this analytics delete message.
	 *
	 * @param analyticsDeleteMessageId the analytics delete message ID of this analytics delete message
	 */
	public void setAnalyticsDeleteMessageId(long analyticsDeleteMessageId);

	/**
	 * Returns the company ID of this analytics delete message.
	 *
	 * @return the company ID of this analytics delete message
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this analytics delete message.
	 *
	 * @param companyId the company ID of this analytics delete message
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this analytics delete message.
	 *
	 * @return the user ID of this analytics delete message
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this analytics delete message.
	 *
	 * @param userId the user ID of this analytics delete message
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this analytics delete message.
	 *
	 * @return the user uuid of this analytics delete message
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this analytics delete message.
	 *
	 * @param userUuid the user uuid of this analytics delete message
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this analytics delete message.
	 *
	 * @return the create date of this analytics delete message
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this analytics delete message.
	 *
	 * @param createDate the create date of this analytics delete message
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this analytics delete message.
	 *
	 * @return the modified date of this analytics delete message
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this analytics delete message.
	 *
	 * @param modifiedDate the modified date of this analytics delete message
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the class name of this analytics delete message.
	 *
	 * @return the class name of this analytics delete message
	 */
	@AutoEscape
	public String getClassName();

	/**
	 * Sets the class name of this analytics delete message.
	 *
	 * @param className the class name of this analytics delete message
	 */
	public void setClassName(String className);

	/**
	 * Returns the class pk of this analytics delete message.
	 *
	 * @return the class pk of this analytics delete message
	 */
	public long getClassPK();

	/**
	 * Sets the class pk of this analytics delete message.
	 *
	 * @param classPK the class pk of this analytics delete message
	 */
	public void setClassPK(long classPK);

	@Override
	public AnalyticsDeleteMessage cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}