/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.sync.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SyncDLFileVersionDiff service. Represents a row in the &quot;SyncDLFileVersionDiff&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.sync.model.impl.SyncDLFileVersionDiffModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.sync.model.impl.SyncDLFileVersionDiffImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SyncDLFileVersionDiff
 * @generated
 */
@ProviderType
public interface SyncDLFileVersionDiffModel
	extends BaseModel<SyncDLFileVersionDiff>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a sync dl file version diff model instance should use the {@link SyncDLFileVersionDiff} interface instead.
	 */

	/**
	 * Returns the primary key of this sync dl file version diff.
	 *
	 * @return the primary key of this sync dl file version diff
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this sync dl file version diff.
	 *
	 * @param primaryKey the primary key of this sync dl file version diff
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the sync dl file version diff ID of this sync dl file version diff.
	 *
	 * @return the sync dl file version diff ID of this sync dl file version diff
	 */
	public long getSyncDLFileVersionDiffId();

	/**
	 * Sets the sync dl file version diff ID of this sync dl file version diff.
	 *
	 * @param syncDLFileVersionDiffId the sync dl file version diff ID of this sync dl file version diff
	 */
	public void setSyncDLFileVersionDiffId(long syncDLFileVersionDiffId);

	/**
	 * Returns the company ID of this sync dl file version diff.
	 *
	 * @return the company ID of this sync dl file version diff
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this sync dl file version diff.
	 *
	 * @param companyId the company ID of this sync dl file version diff
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the file entry ID of this sync dl file version diff.
	 *
	 * @return the file entry ID of this sync dl file version diff
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this sync dl file version diff.
	 *
	 * @param fileEntryId the file entry ID of this sync dl file version diff
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the source file version ID of this sync dl file version diff.
	 *
	 * @return the source file version ID of this sync dl file version diff
	 */
	public long getSourceFileVersionId();

	/**
	 * Sets the source file version ID of this sync dl file version diff.
	 *
	 * @param sourceFileVersionId the source file version ID of this sync dl file version diff
	 */
	public void setSourceFileVersionId(long sourceFileVersionId);

	/**
	 * Returns the target file version ID of this sync dl file version diff.
	 *
	 * @return the target file version ID of this sync dl file version diff
	 */
	public long getTargetFileVersionId();

	/**
	 * Sets the target file version ID of this sync dl file version diff.
	 *
	 * @param targetFileVersionId the target file version ID of this sync dl file version diff
	 */
	public void setTargetFileVersionId(long targetFileVersionId);

	/**
	 * Returns the data file entry ID of this sync dl file version diff.
	 *
	 * @return the data file entry ID of this sync dl file version diff
	 */
	public long getDataFileEntryId();

	/**
	 * Sets the data file entry ID of this sync dl file version diff.
	 *
	 * @param dataFileEntryId the data file entry ID of this sync dl file version diff
	 */
	public void setDataFileEntryId(long dataFileEntryId);

	/**
	 * Returns the size of this sync dl file version diff.
	 *
	 * @return the size of this sync dl file version diff
	 */
	public long getSize();

	/**
	 * Sets the size of this sync dl file version diff.
	 *
	 * @param size the size of this sync dl file version diff
	 */
	public void setSize(long size);

	/**
	 * Returns the expiration date of this sync dl file version diff.
	 *
	 * @return the expiration date of this sync dl file version diff
	 */
	public Date getExpirationDate();

	/**
	 * Sets the expiration date of this sync dl file version diff.
	 *
	 * @param expirationDate the expiration date of this sync dl file version diff
	 */
	public void setExpirationDate(Date expirationDate);

	@Override
	public SyncDLFileVersionDiff cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}