/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.account.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AccountRole service. Represents a row in the &quot;AccountRole&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.account.model.impl.AccountRoleModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.account.model.impl.AccountRoleImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountRole
 * @generated
 */
@ProviderType
public interface AccountRoleModel
	extends BaseModel<AccountRole>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a account role model instance should use the {@link AccountRole} interface instead.
	 */

	/**
	 * Returns the primary key of this account role.
	 *
	 * @return the primary key of this account role
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this account role.
	 *
	 * @param primaryKey the primary key of this account role
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this account role.
	 *
	 * @return the mvcc version of this account role
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this account role.
	 *
	 * @param mvccVersion the mvcc version of this account role
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the account role ID of this account role.
	 *
	 * @return the account role ID of this account role
	 */
	public long getAccountRoleId();

	/**
	 * Sets the account role ID of this account role.
	 *
	 * @param accountRoleId the account role ID of this account role
	 */
	public void setAccountRoleId(long accountRoleId);

	/**
	 * Returns the company ID of this account role.
	 *
	 * @return the company ID of this account role
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this account role.
	 *
	 * @param companyId the company ID of this account role
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the account entry ID of this account role.
	 *
	 * @return the account entry ID of this account role
	 */
	public long getAccountEntryId();

	/**
	 * Sets the account entry ID of this account role.
	 *
	 * @param accountEntryId the account entry ID of this account role
	 */
	public void setAccountEntryId(long accountEntryId);

	/**
	 * Returns the role ID of this account role.
	 *
	 * @return the role ID of this account role
	 */
	public long getRoleId();

	/**
	 * Sets the role ID of this account role.
	 *
	 * @param roleId the role ID of this account role
	 */
	public void setRoleId(long roleId);

	@Override
	public AccountRole cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}