/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.batch.planner.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the BatchPlannerMapping service. Represents a row in the &quot;BatchPlannerMapping&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.batch.planner.model.impl.BatchPlannerMappingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.batch.planner.model.impl.BatchPlannerMappingImpl</code>.
 * </p>
 *
 * @author Igor Beslic
 * @see BatchPlannerMapping
 * @generated
 */
@ProviderType
public interface BatchPlannerMappingModel
	extends AuditedModel, BaseModel<BatchPlannerMapping>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a batch planner mapping model instance should use the {@link BatchPlannerMapping} interface instead.
	 */

	/**
	 * Returns the primary key of this batch planner mapping.
	 *
	 * @return the primary key of this batch planner mapping
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this batch planner mapping.
	 *
	 * @param primaryKey the primary key of this batch planner mapping
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this batch planner mapping.
	 *
	 * @return the mvcc version of this batch planner mapping
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this batch planner mapping.
	 *
	 * @param mvccVersion the mvcc version of this batch planner mapping
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the batch planner mapping ID of this batch planner mapping.
	 *
	 * @return the batch planner mapping ID of this batch planner mapping
	 */
	public long getBatchPlannerMappingId();

	/**
	 * Sets the batch planner mapping ID of this batch planner mapping.
	 *
	 * @param batchPlannerMappingId the batch planner mapping ID of this batch planner mapping
	 */
	public void setBatchPlannerMappingId(long batchPlannerMappingId);

	/**
	 * Returns the company ID of this batch planner mapping.
	 *
	 * @return the company ID of this batch planner mapping
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this batch planner mapping.
	 *
	 * @param companyId the company ID of this batch planner mapping
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this batch planner mapping.
	 *
	 * @return the user ID of this batch planner mapping
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this batch planner mapping.
	 *
	 * @param userId the user ID of this batch planner mapping
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this batch planner mapping.
	 *
	 * @return the user uuid of this batch planner mapping
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this batch planner mapping.
	 *
	 * @param userUuid the user uuid of this batch planner mapping
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this batch planner mapping.
	 *
	 * @return the user name of this batch planner mapping
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this batch planner mapping.
	 *
	 * @param userName the user name of this batch planner mapping
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this batch planner mapping.
	 *
	 * @return the create date of this batch planner mapping
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this batch planner mapping.
	 *
	 * @param createDate the create date of this batch planner mapping
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this batch planner mapping.
	 *
	 * @return the modified date of this batch planner mapping
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this batch planner mapping.
	 *
	 * @param modifiedDate the modified date of this batch planner mapping
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the batch planner plan ID of this batch planner mapping.
	 *
	 * @return the batch planner plan ID of this batch planner mapping
	 */
	public long getBatchPlannerPlanId();

	/**
	 * Sets the batch planner plan ID of this batch planner mapping.
	 *
	 * @param batchPlannerPlanId the batch planner plan ID of this batch planner mapping
	 */
	public void setBatchPlannerPlanId(long batchPlannerPlanId);

	/**
	 * Returns the external field name of this batch planner mapping.
	 *
	 * @return the external field name of this batch planner mapping
	 */
	@AutoEscape
	public String getExternalFieldName();

	/**
	 * Sets the external field name of this batch planner mapping.
	 *
	 * @param externalFieldName the external field name of this batch planner mapping
	 */
	public void setExternalFieldName(String externalFieldName);

	/**
	 * Returns the external field type of this batch planner mapping.
	 *
	 * @return the external field type of this batch planner mapping
	 */
	@AutoEscape
	public String getExternalFieldType();

	/**
	 * Sets the external field type of this batch planner mapping.
	 *
	 * @param externalFieldType the external field type of this batch planner mapping
	 */
	public void setExternalFieldType(String externalFieldType);

	/**
	 * Returns the internal field name of this batch planner mapping.
	 *
	 * @return the internal field name of this batch planner mapping
	 */
	@AutoEscape
	public String getInternalFieldName();

	/**
	 * Sets the internal field name of this batch planner mapping.
	 *
	 * @param internalFieldName the internal field name of this batch planner mapping
	 */
	public void setInternalFieldName(String internalFieldName);

	/**
	 * Returns the internal field type of this batch planner mapping.
	 *
	 * @return the internal field type of this batch planner mapping
	 */
	@AutoEscape
	public String getInternalFieldType();

	/**
	 * Sets the internal field type of this batch planner mapping.
	 *
	 * @param internalFieldType the internal field type of this batch planner mapping
	 */
	public void setInternalFieldType(String internalFieldType);

	/**
	 * Returns the script of this batch planner mapping.
	 *
	 * @return the script of this batch planner mapping
	 */
	@AutoEscape
	public String getScript();

	/**
	 * Sets the script of this batch planner mapping.
	 *
	 * @param script the script of this batch planner mapping
	 */
	public void setScript(String script);

	@Override
	public BatchPlannerMapping cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}