/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.wish.list.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceWishListItem service. Represents a row in the &quot;CommerceWishListItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.wish.list.model.impl.CommerceWishListItemModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.wish.list.model.impl.CommerceWishListItemImpl</code>.
 * </p>
 *
 * @author Andrea Di Giorgi
 * @see CommerceWishListItem
 * @generated
 */
@ProviderType
public interface CommerceWishListItemModel
	extends BaseModel<CommerceWishListItem>, GroupedModel, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce wish list item model instance should use the {@link CommerceWishListItem} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce wish list item.
	 *
	 * @return the primary key of this commerce wish list item
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce wish list item.
	 *
	 * @param primaryKey the primary key of this commerce wish list item
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce wish list item.
	 *
	 * @return the mvcc version of this commerce wish list item
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce wish list item.
	 *
	 * @param mvccVersion the mvcc version of this commerce wish list item
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the commerce wish list item ID of this commerce wish list item.
	 *
	 * @return the commerce wish list item ID of this commerce wish list item
	 */
	public long getCommerceWishListItemId();

	/**
	 * Sets the commerce wish list item ID of this commerce wish list item.
	 *
	 * @param commerceWishListItemId the commerce wish list item ID of this commerce wish list item
	 */
	public void setCommerceWishListItemId(long commerceWishListItemId);

	/**
	 * Returns the group ID of this commerce wish list item.
	 *
	 * @return the group ID of this commerce wish list item
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce wish list item.
	 *
	 * @param groupId the group ID of this commerce wish list item
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce wish list item.
	 *
	 * @return the company ID of this commerce wish list item
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce wish list item.
	 *
	 * @param companyId the company ID of this commerce wish list item
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce wish list item.
	 *
	 * @return the user ID of this commerce wish list item
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce wish list item.
	 *
	 * @param userId the user ID of this commerce wish list item
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce wish list item.
	 *
	 * @return the user uuid of this commerce wish list item
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce wish list item.
	 *
	 * @param userUuid the user uuid of this commerce wish list item
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce wish list item.
	 *
	 * @return the user name of this commerce wish list item
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce wish list item.
	 *
	 * @param userName the user name of this commerce wish list item
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce wish list item.
	 *
	 * @return the create date of this commerce wish list item
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce wish list item.
	 *
	 * @param createDate the create date of this commerce wish list item
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce wish list item.
	 *
	 * @return the modified date of this commerce wish list item
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce wish list item.
	 *
	 * @param modifiedDate the modified date of this commerce wish list item
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce wish list ID of this commerce wish list item.
	 *
	 * @return the commerce wish list ID of this commerce wish list item
	 */
	public long getCommerceWishListId();

	/**
	 * Sets the commerce wish list ID of this commerce wish list item.
	 *
	 * @param commerceWishListId the commerce wish list ID of this commerce wish list item
	 */
	public void setCommerceWishListId(long commerceWishListId);

	/**
	 * Returns the cp instance uuid of this commerce wish list item.
	 *
	 * @return the cp instance uuid of this commerce wish list item
	 */
	@AutoEscape
	public String getCPInstanceUuid();

	/**
	 * Sets the cp instance uuid of this commerce wish list item.
	 *
	 * @param CPInstanceUuid the cp instance uuid of this commerce wish list item
	 */
	public void setCPInstanceUuid(String CPInstanceUuid);

	/**
	 * Returns the c product ID of this commerce wish list item.
	 *
	 * @return the c product ID of this commerce wish list item
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this commerce wish list item.
	 *
	 * @param CProductId the c product ID of this commerce wish list item
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the json of this commerce wish list item.
	 *
	 * @return the json of this commerce wish list item
	 */
	@AutoEscape
	public String getJson();

	/**
	 * Sets the json of this commerce wish list item.
	 *
	 * @param json the json of this commerce wish list item
	 */
	public void setJson(String json);

	@Override
	public CommerceWishListItem cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}