/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.fragment.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.model.version.VersionModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the FragmentEntryVersion service. Represents a row in the &quot;FragmentEntryVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.fragment.model.impl.FragmentEntryVersionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.fragment.model.impl.FragmentEntryVersionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FragmentEntryVersion
 * @generated
 */
@ProviderType
public interface FragmentEntryVersionModel
	extends BaseModel<FragmentEntryVersion>, CTModel<FragmentEntryVersion>,
			GroupedModel, MVCCModel, ShardedModel, VersionModel<FragmentEntry>,
			WorkflowedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a fragment entry version model instance should use the {@link FragmentEntryVersion} interface instead.
	 */

	/**
	 * Returns the primary key of this fragment entry version.
	 *
	 * @return the primary key of this fragment entry version
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this fragment entry version.
	 *
	 * @param primaryKey the primary key of this fragment entry version
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this fragment entry version.
	 *
	 * @return the mvcc version of this fragment entry version
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this fragment entry version.
	 *
	 * @param mvccVersion the mvcc version of this fragment entry version
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this fragment entry version.
	 *
	 * @return the ct collection ID of this fragment entry version
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this fragment entry version.
	 *
	 * @param ctCollectionId the ct collection ID of this fragment entry version
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the fragment entry version ID of this fragment entry version.
	 *
	 * @return the fragment entry version ID of this fragment entry version
	 */
	public long getFragmentEntryVersionId();

	/**
	 * Sets the fragment entry version ID of this fragment entry version.
	 *
	 * @param fragmentEntryVersionId the fragment entry version ID of this fragment entry version
	 */
	public void setFragmentEntryVersionId(long fragmentEntryVersionId);

	/**
	 * Returns the version of this fragment entry version.
	 *
	 * @return the version of this fragment entry version
	 */
	@Override
	public int getVersion();

	/**
	 * Sets the version of this fragment entry version.
	 *
	 * @param version the version of this fragment entry version
	 */
	@Override
	public void setVersion(int version);

	/**
	 * Returns the uuid of this fragment entry version.
	 *
	 * @return the uuid of this fragment entry version
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this fragment entry version.
	 *
	 * @param uuid the uuid of this fragment entry version
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the fragment entry ID of this fragment entry version.
	 *
	 * @return the fragment entry ID of this fragment entry version
	 */
	public long getFragmentEntryId();

	/**
	 * Sets the fragment entry ID of this fragment entry version.
	 *
	 * @param fragmentEntryId the fragment entry ID of this fragment entry version
	 */
	public void setFragmentEntryId(long fragmentEntryId);

	/**
	 * Returns the group ID of this fragment entry version.
	 *
	 * @return the group ID of this fragment entry version
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this fragment entry version.
	 *
	 * @param groupId the group ID of this fragment entry version
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this fragment entry version.
	 *
	 * @return the company ID of this fragment entry version
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this fragment entry version.
	 *
	 * @param companyId the company ID of this fragment entry version
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this fragment entry version.
	 *
	 * @return the user ID of this fragment entry version
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this fragment entry version.
	 *
	 * @param userId the user ID of this fragment entry version
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this fragment entry version.
	 *
	 * @return the user uuid of this fragment entry version
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this fragment entry version.
	 *
	 * @param userUuid the user uuid of this fragment entry version
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this fragment entry version.
	 *
	 * @return the user name of this fragment entry version
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this fragment entry version.
	 *
	 * @param userName the user name of this fragment entry version
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this fragment entry version.
	 *
	 * @return the create date of this fragment entry version
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this fragment entry version.
	 *
	 * @param createDate the create date of this fragment entry version
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this fragment entry version.
	 *
	 * @return the modified date of this fragment entry version
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this fragment entry version.
	 *
	 * @param modifiedDate the modified date of this fragment entry version
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fragment collection ID of this fragment entry version.
	 *
	 * @return the fragment collection ID of this fragment entry version
	 */
	public long getFragmentCollectionId();

	/**
	 * Sets the fragment collection ID of this fragment entry version.
	 *
	 * @param fragmentCollectionId the fragment collection ID of this fragment entry version
	 */
	public void setFragmentCollectionId(long fragmentCollectionId);

	/**
	 * Returns the fragment entry key of this fragment entry version.
	 *
	 * @return the fragment entry key of this fragment entry version
	 */
	@AutoEscape
	public String getFragmentEntryKey();

	/**
	 * Sets the fragment entry key of this fragment entry version.
	 *
	 * @param fragmentEntryKey the fragment entry key of this fragment entry version
	 */
	public void setFragmentEntryKey(String fragmentEntryKey);

	/**
	 * Returns the name of this fragment entry version.
	 *
	 * @return the name of this fragment entry version
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this fragment entry version.
	 *
	 * @param name the name of this fragment entry version
	 */
	public void setName(String name);

	/**
	 * Returns the css of this fragment entry version.
	 *
	 * @return the css of this fragment entry version
	 */
	@AutoEscape
	public String getCss();

	/**
	 * Sets the css of this fragment entry version.
	 *
	 * @param css the css of this fragment entry version
	 */
	public void setCss(String css);

	/**
	 * Returns the html of this fragment entry version.
	 *
	 * @return the html of this fragment entry version
	 */
	@AutoEscape
	public String getHtml();

	/**
	 * Sets the html of this fragment entry version.
	 *
	 * @param html the html of this fragment entry version
	 */
	public void setHtml(String html);

	/**
	 * Returns the js of this fragment entry version.
	 *
	 * @return the js of this fragment entry version
	 */
	@AutoEscape
	public String getJs();

	/**
	 * Sets the js of this fragment entry version.
	 *
	 * @param js the js of this fragment entry version
	 */
	public void setJs(String js);

	/**
	 * Returns the cacheable of this fragment entry version.
	 *
	 * @return the cacheable of this fragment entry version
	 */
	public boolean getCacheable();

	/**
	 * Returns <code>true</code> if this fragment entry version is cacheable.
	 *
	 * @return <code>true</code> if this fragment entry version is cacheable; <code>false</code> otherwise
	 */
	public boolean isCacheable();

	/**
	 * Sets whether this fragment entry version is cacheable.
	 *
	 * @param cacheable the cacheable of this fragment entry version
	 */
	public void setCacheable(boolean cacheable);

	/**
	 * Returns the configuration of this fragment entry version.
	 *
	 * @return the configuration of this fragment entry version
	 */
	@AutoEscape
	public String getConfiguration();

	/**
	 * Sets the configuration of this fragment entry version.
	 *
	 * @param configuration the configuration of this fragment entry version
	 */
	public void setConfiguration(String configuration);

	/**
	 * Returns the icon of this fragment entry version.
	 *
	 * @return the icon of this fragment entry version
	 */
	@AutoEscape
	public String getIcon();

	/**
	 * Sets the icon of this fragment entry version.
	 *
	 * @param icon the icon of this fragment entry version
	 */
	public void setIcon(String icon);

	/**
	 * Returns the preview file entry ID of this fragment entry version.
	 *
	 * @return the preview file entry ID of this fragment entry version
	 */
	public long getPreviewFileEntryId();

	/**
	 * Sets the preview file entry ID of this fragment entry version.
	 *
	 * @param previewFileEntryId the preview file entry ID of this fragment entry version
	 */
	public void setPreviewFileEntryId(long previewFileEntryId);

	/**
	 * Returns the read only of this fragment entry version.
	 *
	 * @return the read only of this fragment entry version
	 */
	public boolean getReadOnly();

	/**
	 * Returns <code>true</code> if this fragment entry version is read only.
	 *
	 * @return <code>true</code> if this fragment entry version is read only; <code>false</code> otherwise
	 */
	public boolean isReadOnly();

	/**
	 * Sets whether this fragment entry version is read only.
	 *
	 * @param readOnly the read only of this fragment entry version
	 */
	public void setReadOnly(boolean readOnly);

	/**
	 * Returns the type of this fragment entry version.
	 *
	 * @return the type of this fragment entry version
	 */
	public int getType();

	/**
	 * Sets the type of this fragment entry version.
	 *
	 * @param type the type of this fragment entry version
	 */
	public void setType(int type);

	/**
	 * Returns the type options of this fragment entry version.
	 *
	 * @return the type options of this fragment entry version
	 */
	@AutoEscape
	public String getTypeOptions();

	/**
	 * Sets the type options of this fragment entry version.
	 *
	 * @param typeOptions the type options of this fragment entry version
	 */
	public void setTypeOptions(String typeOptions);

	/**
	 * Returns the last publish date of this fragment entry version.
	 *
	 * @return the last publish date of this fragment entry version
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this fragment entry version.
	 *
	 * @param lastPublishDate the last publish date of this fragment entry version
	 */
	public void setLastPublishDate(Date lastPublishDate);

	/**
	 * Returns the status of this fragment entry version.
	 *
	 * @return the status of this fragment entry version
	 */
	@Override
	public int getStatus();

	/**
	 * Sets the status of this fragment entry version.
	 *
	 * @param status the status of this fragment entry version
	 */
	@Override
	public void setStatus(int status);

	/**
	 * Returns the status by user ID of this fragment entry version.
	 *
	 * @return the status by user ID of this fragment entry version
	 */
	@Override
	public long getStatusByUserId();

	/**
	 * Sets the status by user ID of this fragment entry version.
	 *
	 * @param statusByUserId the status by user ID of this fragment entry version
	 */
	@Override
	public void setStatusByUserId(long statusByUserId);

	/**
	 * Returns the status by user uuid of this fragment entry version.
	 *
	 * @return the status by user uuid of this fragment entry version
	 */
	@Override
	public String getStatusByUserUuid();

	/**
	 * Sets the status by user uuid of this fragment entry version.
	 *
	 * @param statusByUserUuid the status by user uuid of this fragment entry version
	 */
	@Override
	public void setStatusByUserUuid(String statusByUserUuid);

	/**
	 * Returns the status by user name of this fragment entry version.
	 *
	 * @return the status by user name of this fragment entry version
	 */
	@AutoEscape
	@Override
	public String getStatusByUserName();

	/**
	 * Sets the status by user name of this fragment entry version.
	 *
	 * @param statusByUserName the status by user name of this fragment entry version
	 */
	@Override
	public void setStatusByUserName(String statusByUserName);

	/**
	 * Returns the status date of this fragment entry version.
	 *
	 * @return the status date of this fragment entry version
	 */
	@Override
	public Date getStatusDate();

	/**
	 * Sets the status date of this fragment entry version.
	 *
	 * @param statusDate the status date of this fragment entry version
	 */
	@Override
	public void setStatusDate(Date statusDate);

	/**
	 * Returns <code>true</code> if this fragment entry version is approved.
	 *
	 * @return <code>true</code> if this fragment entry version is approved; <code>false</code> otherwise
	 */
	@Override
	public boolean isApproved();

	/**
	 * Returns <code>true</code> if this fragment entry version is denied.
	 *
	 * @return <code>true</code> if this fragment entry version is denied; <code>false</code> otherwise
	 */
	@Override
	public boolean isDenied();

	/**
	 * Returns <code>true</code> if this fragment entry version is a draft.
	 *
	 * @return <code>true</code> if this fragment entry version is a draft; <code>false</code> otherwise
	 */
	@Override
	public boolean isDraft();

	/**
	 * Returns <code>true</code> if this fragment entry version is expired.
	 *
	 * @return <code>true</code> if this fragment entry version is expired; <code>false</code> otherwise
	 */
	@Override
	public boolean isExpired();

	/**
	 * Returns <code>true</code> if this fragment entry version is inactive.
	 *
	 * @return <code>true</code> if this fragment entry version is inactive; <code>false</code> otherwise
	 */
	@Override
	public boolean isInactive();

	/**
	 * Returns <code>true</code> if this fragment entry version is incomplete.
	 *
	 * @return <code>true</code> if this fragment entry version is incomplete; <code>false</code> otherwise
	 */
	@Override
	public boolean isIncomplete();

	/**
	 * Returns <code>true</code> if this fragment entry version is pending.
	 *
	 * @return <code>true</code> if this fragment entry version is pending; <code>false</code> otherwise
	 */
	@Override
	public boolean isPending();

	/**
	 * Returns <code>true</code> if this fragment entry version is scheduled.
	 *
	 * @return <code>true</code> if this fragment entry version is scheduled; <code>false</code> otherwise
	 */
	@Override
	public boolean isScheduled();

	@Override
	public FragmentEntryVersion cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}