/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the UserGroupRole service. Represents a row in the &quot;UserGroupRole&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.model.impl.UserGroupRoleModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.model.impl.UserGroupRoleImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserGroupRole
 * @generated
 */
@ProviderType
public interface UserGroupRoleModel
	extends BaseModel<UserGroupRole>, CTModel<UserGroupRole>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a user group role model instance should use the {@link UserGroupRole} interface instead.
	 */

	/**
	 * Returns the primary key of this user group role.
	 *
	 * @return the primary key of this user group role
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this user group role.
	 *
	 * @param primaryKey the primary key of this user group role
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this user group role.
	 *
	 * @return the mvcc version of this user group role
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this user group role.
	 *
	 * @param mvccVersion the mvcc version of this user group role
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this user group role.
	 *
	 * @return the ct collection ID of this user group role
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this user group role.
	 *
	 * @param ctCollectionId the ct collection ID of this user group role
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the user group role ID of this user group role.
	 *
	 * @return the user group role ID of this user group role
	 */
	public long getUserGroupRoleId();

	/**
	 * Sets the user group role ID of this user group role.
	 *
	 * @param userGroupRoleId the user group role ID of this user group role
	 */
	public void setUserGroupRoleId(long userGroupRoleId);

	/**
	 * Returns the company ID of this user group role.
	 *
	 * @return the company ID of this user group role
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this user group role.
	 *
	 * @param companyId the company ID of this user group role
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this user group role.
	 *
	 * @return the user ID of this user group role
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this user group role.
	 *
	 * @param userId the user ID of this user group role
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this user group role.
	 *
	 * @return the user uuid of this user group role
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this user group role.
	 *
	 * @param userUuid the user uuid of this user group role
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the group ID of this user group role.
	 *
	 * @return the group ID of this user group role
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this user group role.
	 *
	 * @param groupId the group ID of this user group role
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the role ID of this user group role.
	 *
	 * @return the role ID of this user group role
	 */
	public long getRoleId();

	/**
	 * Sets the role ID of this user group role.
	 *
	 * @param roleId the role ID of this user group role
	 */
	public void setRoleId(long roleId);

	@Override
	public UserGroupRole cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}