/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.account.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AccountEntry service. Represents a row in the &quot;AccountEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.account.model.impl.AccountEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.account.model.impl.AccountEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountEntry
 * @generated
 */
@ProviderType
public interface AccountEntryModel
	extends BaseModel<AccountEntry>, MVCCModel, ShardedModel,
			StagedAuditedModel, WorkflowedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a account entry model instance should use the {@link AccountEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this account entry.
	 *
	 * @return the primary key of this account entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this account entry.
	 *
	 * @param primaryKey the primary key of this account entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this account entry.
	 *
	 * @return the mvcc version of this account entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this account entry.
	 *
	 * @param mvccVersion the mvcc version of this account entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this account entry.
	 *
	 * @return the uuid of this account entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this account entry.
	 *
	 * @param uuid the uuid of this account entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this account entry.
	 *
	 * @return the external reference code of this account entry
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this account entry.
	 *
	 * @param externalReferenceCode the external reference code of this account entry
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the account entry ID of this account entry.
	 *
	 * @return the account entry ID of this account entry
	 */
	public long getAccountEntryId();

	/**
	 * Sets the account entry ID of this account entry.
	 *
	 * @param accountEntryId the account entry ID of this account entry
	 */
	public void setAccountEntryId(long accountEntryId);

	/**
	 * Returns the company ID of this account entry.
	 *
	 * @return the company ID of this account entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this account entry.
	 *
	 * @param companyId the company ID of this account entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this account entry.
	 *
	 * @return the user ID of this account entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this account entry.
	 *
	 * @param userId the user ID of this account entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this account entry.
	 *
	 * @return the user uuid of this account entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this account entry.
	 *
	 * @param userUuid the user uuid of this account entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this account entry.
	 *
	 * @return the user name of this account entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this account entry.
	 *
	 * @param userName the user name of this account entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this account entry.
	 *
	 * @return the create date of this account entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this account entry.
	 *
	 * @param createDate the create date of this account entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this account entry.
	 *
	 * @return the modified date of this account entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this account entry.
	 *
	 * @param modifiedDate the modified date of this account entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the default billing address ID of this account entry.
	 *
	 * @return the default billing address ID of this account entry
	 */
	public long getDefaultBillingAddressId();

	/**
	 * Sets the default billing address ID of this account entry.
	 *
	 * @param defaultBillingAddressId the default billing address ID of this account entry
	 */
	public void setDefaultBillingAddressId(long defaultBillingAddressId);

	/**
	 * Returns the default c payment method key of this account entry.
	 *
	 * @return the default c payment method key of this account entry
	 */
	@AutoEscape
	public String getDefaultCPaymentMethodKey();

	/**
	 * Sets the default c payment method key of this account entry.
	 *
	 * @param defaultCPaymentMethodKey the default c payment method key of this account entry
	 */
	public void setDefaultCPaymentMethodKey(String defaultCPaymentMethodKey);

	/**
	 * Returns the default shipping address ID of this account entry.
	 *
	 * @return the default shipping address ID of this account entry
	 */
	public long getDefaultShippingAddressId();

	/**
	 * Sets the default shipping address ID of this account entry.
	 *
	 * @param defaultShippingAddressId the default shipping address ID of this account entry
	 */
	public void setDefaultShippingAddressId(long defaultShippingAddressId);

	/**
	 * Returns the parent account entry ID of this account entry.
	 *
	 * @return the parent account entry ID of this account entry
	 */
	public long getParentAccountEntryId();

	/**
	 * Sets the parent account entry ID of this account entry.
	 *
	 * @param parentAccountEntryId the parent account entry ID of this account entry
	 */
	public void setParentAccountEntryId(long parentAccountEntryId);

	/**
	 * Returns the description of this account entry.
	 *
	 * @return the description of this account entry
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this account entry.
	 *
	 * @param description the description of this account entry
	 */
	public void setDescription(String description);

	/**
	 * Returns the domains of this account entry.
	 *
	 * @return the domains of this account entry
	 */
	@AutoEscape
	public String getDomains();

	/**
	 * Sets the domains of this account entry.
	 *
	 * @param domains the domains of this account entry
	 */
	public void setDomains(String domains);

	/**
	 * Returns the email address of this account entry.
	 *
	 * @return the email address of this account entry
	 */
	@AutoEscape
	public String getEmailAddress();

	/**
	 * Sets the email address of this account entry.
	 *
	 * @param emailAddress the email address of this account entry
	 */
	public void setEmailAddress(String emailAddress);

	/**
	 * Returns the logo ID of this account entry.
	 *
	 * @return the logo ID of this account entry
	 */
	public long getLogoId();

	/**
	 * Sets the logo ID of this account entry.
	 *
	 * @param logoId the logo ID of this account entry
	 */
	public void setLogoId(long logoId);

	/**
	 * Returns the name of this account entry.
	 *
	 * @return the name of this account entry
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this account entry.
	 *
	 * @param name the name of this account entry
	 */
	public void setName(String name);

	/**
	 * Returns the restrict membership of this account entry.
	 *
	 * @return the restrict membership of this account entry
	 */
	public boolean getRestrictMembership();

	/**
	 * Returns <code>true</code> if this account entry is restrict membership.
	 *
	 * @return <code>true</code> if this account entry is restrict membership; <code>false</code> otherwise
	 */
	public boolean isRestrictMembership();

	/**
	 * Sets whether this account entry is restrict membership.
	 *
	 * @param restrictMembership the restrict membership of this account entry
	 */
	public void setRestrictMembership(boolean restrictMembership);

	/**
	 * Returns the tax exemption code of this account entry.
	 *
	 * @return the tax exemption code of this account entry
	 */
	@AutoEscape
	public String getTaxExemptionCode();

	/**
	 * Sets the tax exemption code of this account entry.
	 *
	 * @param taxExemptionCode the tax exemption code of this account entry
	 */
	public void setTaxExemptionCode(String taxExemptionCode);

	/**
	 * Returns the tax ID number of this account entry.
	 *
	 * @return the tax ID number of this account entry
	 */
	@AutoEscape
	public String getTaxIdNumber();

	/**
	 * Sets the tax ID number of this account entry.
	 *
	 * @param taxIdNumber the tax ID number of this account entry
	 */
	public void setTaxIdNumber(String taxIdNumber);

	/**
	 * Returns the type of this account entry.
	 *
	 * @return the type of this account entry
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this account entry.
	 *
	 * @param type the type of this account entry
	 */
	public void setType(String type);

	/**
	 * Returns the status of this account entry.
	 *
	 * @return the status of this account entry
	 */
	@Override
	public int getStatus();

	/**
	 * Sets the status of this account entry.
	 *
	 * @param status the status of this account entry
	 */
	@Override
	public void setStatus(int status);

	/**
	 * Returns the status by user ID of this account entry.
	 *
	 * @return the status by user ID of this account entry
	 */
	@Override
	public long getStatusByUserId();

	/**
	 * Sets the status by user ID of this account entry.
	 *
	 * @param statusByUserId the status by user ID of this account entry
	 */
	@Override
	public void setStatusByUserId(long statusByUserId);

	/**
	 * Returns the status by user uuid of this account entry.
	 *
	 * @return the status by user uuid of this account entry
	 */
	@Override
	public String getStatusByUserUuid();

	/**
	 * Sets the status by user uuid of this account entry.
	 *
	 * @param statusByUserUuid the status by user uuid of this account entry
	 */
	@Override
	public void setStatusByUserUuid(String statusByUserUuid);

	/**
	 * Returns the status by user name of this account entry.
	 *
	 * @return the status by user name of this account entry
	 */
	@AutoEscape
	@Override
	public String getStatusByUserName();

	/**
	 * Sets the status by user name of this account entry.
	 *
	 * @param statusByUserName the status by user name of this account entry
	 */
	@Override
	public void setStatusByUserName(String statusByUserName);

	/**
	 * Returns the status date of this account entry.
	 *
	 * @return the status date of this account entry
	 */
	@Override
	public Date getStatusDate();

	/**
	 * Sets the status date of this account entry.
	 *
	 * @param statusDate the status date of this account entry
	 */
	@Override
	public void setStatusDate(Date statusDate);

	/**
	 * Returns <code>true</code> if this account entry is approved.
	 *
	 * @return <code>true</code> if this account entry is approved; <code>false</code> otherwise
	 */
	@Override
	public boolean isApproved();

	/**
	 * Returns <code>true</code> if this account entry is denied.
	 *
	 * @return <code>true</code> if this account entry is denied; <code>false</code> otherwise
	 */
	@Override
	public boolean isDenied();

	/**
	 * Returns <code>true</code> if this account entry is a draft.
	 *
	 * @return <code>true</code> if this account entry is a draft; <code>false</code> otherwise
	 */
	@Override
	public boolean isDraft();

	/**
	 * Returns <code>true</code> if this account entry is expired.
	 *
	 * @return <code>true</code> if this account entry is expired; <code>false</code> otherwise
	 */
	@Override
	public boolean isExpired();

	/**
	 * Returns <code>true</code> if this account entry is inactive.
	 *
	 * @return <code>true</code> if this account entry is inactive; <code>false</code> otherwise
	 */
	@Override
	public boolean isInactive();

	/**
	 * Returns <code>true</code> if this account entry is incomplete.
	 *
	 * @return <code>true</code> if this account entry is incomplete; <code>false</code> otherwise
	 */
	@Override
	public boolean isIncomplete();

	/**
	 * Returns <code>true</code> if this account entry is pending.
	 *
	 * @return <code>true</code> if this account entry is pending; <code>false</code> otherwise
	 */
	@Override
	public boolean isPending();

	/**
	 * Returns <code>true</code> if this account entry is scheduled.
	 *
	 * @return <code>true</code> if this account entry is scheduled; <code>false</code> otherwise
	 */
	@Override
	public boolean isScheduled();

	@Override
	public AccountEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}