/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.document.library.file.rank.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DLFileRank service. Represents a row in the &quot;DLFileRank&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.document.library.file.rank.model.impl.DLFileRankModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.document.library.file.rank.model.impl.DLFileRankImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileRank
 * @generated
 */
@ProviderType
public interface DLFileRankModel
	extends BaseModel<DLFileRank>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a document library file rank model instance should use the {@link DLFileRank} interface instead.
	 */

	/**
	 * Returns the primary key of this document library file rank.
	 *
	 * @return the primary key of this document library file rank
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this document library file rank.
	 *
	 * @param primaryKey the primary key of this document library file rank
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this document library file rank.
	 *
	 * @return the mvcc version of this document library file rank
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this document library file rank.
	 *
	 * @param mvccVersion the mvcc version of this document library file rank
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the file rank ID of this document library file rank.
	 *
	 * @return the file rank ID of this document library file rank
	 */
	public long getFileRankId();

	/**
	 * Sets the file rank ID of this document library file rank.
	 *
	 * @param fileRankId the file rank ID of this document library file rank
	 */
	public void setFileRankId(long fileRankId);

	/**
	 * Returns the group ID of this document library file rank.
	 *
	 * @return the group ID of this document library file rank
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this document library file rank.
	 *
	 * @param groupId the group ID of this document library file rank
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this document library file rank.
	 *
	 * @return the company ID of this document library file rank
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this document library file rank.
	 *
	 * @param companyId the company ID of this document library file rank
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this document library file rank.
	 *
	 * @return the user ID of this document library file rank
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this document library file rank.
	 *
	 * @param userId the user ID of this document library file rank
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this document library file rank.
	 *
	 * @return the user uuid of this document library file rank
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this document library file rank.
	 *
	 * @param userUuid the user uuid of this document library file rank
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this document library file rank.
	 *
	 * @return the create date of this document library file rank
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this document library file rank.
	 *
	 * @param createDate the create date of this document library file rank
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the file entry ID of this document library file rank.
	 *
	 * @return the file entry ID of this document library file rank
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this document library file rank.
	 *
	 * @param fileEntryId the file entry ID of this document library file rank
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the active of this document library file rank.
	 *
	 * @return the active of this document library file rank
	 */
	public boolean getActive();

	/**
	 * Returns <code>true</code> if this document library file rank is active.
	 *
	 * @return <code>true</code> if this document library file rank is active; <code>false</code> otherwise
	 */
	public boolean isActive();

	/**
	 * Sets whether this document library file rank is active.
	 *
	 * @param active the active of this document library file rank
	 */
	public void setActive(boolean active);

	@Override
	public DLFileRank cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}