/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.portlet.constants;

import com.liferay.portal.kernel.util.Portal;

/**
 * @author Guilherme Camacho
 */
public class FriendlyURLResolverConstants {

	public static final String URL_SEPARATOR_ASSET_CATEGORY = "/v/";

	public static final String URL_SEPARATOR_BLOGS_ENTRY = "/b/";

	public static final String URL_SEPARATOR_FILE_ENTRY = "/d/";

	public static final String URL_SEPARATOR_JOURNAL_ARTICLE = "/w/";

	public static final String URL_SEPARATOR_KNOWLEDGE_BASE_ARTICLE = "/k/";

	public static final String URL_SEPARATOR_OBJECT_ENTRY = "/l/";

	public static final String URL_SEPARATOR_PORTAL_RESERVED =
		Portal.PATH_MODULE + "/";

	public static final String URL_SEPARATOR_X_ASSET_CATEGORY = "/v";

	public static final String URL_SEPARATOR_X_BLOGS_ENTRY = "/b";

	public static final String URL_SEPARATOR_X_FILE_ENTRY = "/d";

	public static final String URL_SEPARATOR_X_JOURNAL_ARTICLE = "/w";

	public static final String URL_SEPARATOR_X_OBJECT_ENTRY = "/l";

	public static final String URL_SEPARATOR_X_PORTAL_RESERVED =
		Portal.PATH_MODULE;

	public static final String URL_SEPARATOR_Y_ASSET_CATEGORY = "v";

	public static final String URL_SEPARATOR_Y_BLOGS_ENTRY = "b";

	public static final String URL_SEPARATOR_Y_FILE_ENTRY = "d";

	public static final String URL_SEPARATOR_Y_JOURNAL_ARTICLE = "w";

	public static final String URL_SEPARATOR_Y_OBJECT_ENTRY = "l";

	public static final String URL_SEPARATOR_Y_PORTAL_RESERVED =
		URL_SEPARATOR_X_PORTAL_RESERVED.substring(1);

}