package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ServiceAccountListBuilder extends io.fabric8.kubernetes.api.model.ServiceAccountListFluentImpl<io.fabric8.kubernetes.api.model.ServiceAccountListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceAccountList,io.fabric8.kubernetes.api.model.ServiceAccountListBuilder>{
  public ServiceAccountListBuilder() {
    this(false);
  }
  public ServiceAccountListBuilder(java.lang.Boolean validationEnabled) {
    this(new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccountList instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccountList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountList instance) {
    this(instance,false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceAccountList build() {
    ServiceAccountList buildable = new ServiceAccountList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceAccountListBuilder that = (ServiceAccountListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}