package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class IngressServiceBackendBuilder extends io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder>{
  public IngressServiceBackendBuilder() {
    this(false);
  }
  public IngressServiceBackendBuilder(java.lang.Boolean validationEnabled) {
    this(new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance) {
    this(fluent, instance, false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance) {
    this(instance,false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend build() {
    IngressServiceBackend buildable = new IngressServiceBackend(fluent.getName(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressServiceBackendBuilder that = (IngressServiceBackendBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}