/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.kubernetes.client;

public class ApiextensionsAPIGroupExtensionAdapter extends APIGroupExtensionAdapter<ApiextensionsAPIGroupClient> {

  @Override
  protected String getAPIGroupName() {
    return "apiextension";
  }

  @Override
  public Class<ApiextensionsAPIGroupClient> getExtensionType() {
    return ApiextensionsAPIGroupClient.class;
  }

  @Override
  protected ApiextensionsAPIGroupClient newInstance(Client client) {
    return new ApiextensionsAPIGroupClient(client);
  }

}
