/**
 * Copyright (c) 2008, SnakeYAML
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.yaml.snakeyaml.constructor;

/**
 * Construct instances with a custom Class Loader.
 */
public class CustomClassLoaderConstructor extends Constructor {

  private ClassLoader loader = CustomClassLoaderConstructor.class.getClassLoader();

  public CustomClassLoaderConstructor(ClassLoader cLoader) {
    this(Object.class, cLoader);
  }

  public CustomClassLoaderConstructor(Class<? extends Object> theRoot, ClassLoader theLoader) {
    super(theRoot);
    if (theLoader == null) {
      throw new NullPointerException("Loader must be provided.");
    }
    this.loader = theLoader;
  }

  @Override
  protected Class<?> getClassForName(String name) throws ClassNotFoundException {
    return Class.forName(name, true, loader);
  }
}
