/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.adaptive.media.handler;

import com.liferay.adaptive.media.AdaptiveMedia;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/**
 * Handles upcoming requests for a particular kind of media (i.e., media
 * generated by one type of processor).
 *
 * @author Adolfo Pérez
 */
public interface AMRequestHandler<T> {

	/**
	 * Returns the requested {@link AdaptiveMedia} instance. If no media is found matching the request, or an
	 * application error is raised while fetching the media, a null value is
	 * returned.
	 *
	 * @param  httpServletRequest the request to process
	 * @return a {@link AdaptiveMedia} instance or null.
	 * @throws IOException if an IO error occurred while processing the request
	 * @throws ServletException if any other processing error occurred
	 */
	public AdaptiveMedia<T> handleRequest(HttpServletRequest httpServletRequest)
		throws IOException, ServletException;

}