/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPDefinitionLink service. Represents a row in the &quot;CPDefinitionLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.model.impl.CPDefinitionLinkModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.model.impl.CPDefinitionLinkImpl</code>.
 * </p>
 *
 * @author Marco Leo
 * @see CPDefinitionLink
 * @generated
 */
@ProviderType
public interface CPDefinitionLinkModel
	extends BaseModel<CPDefinitionLink>, CTModel<CPDefinitionLink>,
			GroupedModel, MVCCModel, ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp definition link model instance should use the {@link CPDefinitionLink} interface instead.
	 */

	/**
	 * Returns the primary key of this cp definition link.
	 *
	 * @return the primary key of this cp definition link
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp definition link.
	 *
	 * @param primaryKey the primary key of this cp definition link
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this cp definition link.
	 *
	 * @return the mvcc version of this cp definition link
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this cp definition link.
	 *
	 * @param mvccVersion the mvcc version of this cp definition link
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this cp definition link.
	 *
	 * @return the ct collection ID of this cp definition link
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this cp definition link.
	 *
	 * @param ctCollectionId the ct collection ID of this cp definition link
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this cp definition link.
	 *
	 * @return the uuid of this cp definition link
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cp definition link.
	 *
	 * @param uuid the uuid of this cp definition link
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cp definition link ID of this cp definition link.
	 *
	 * @return the cp definition link ID of this cp definition link
	 */
	public long getCPDefinitionLinkId();

	/**
	 * Sets the cp definition link ID of this cp definition link.
	 *
	 * @param CPDefinitionLinkId the cp definition link ID of this cp definition link
	 */
	public void setCPDefinitionLinkId(long CPDefinitionLinkId);

	/**
	 * Returns the group ID of this cp definition link.
	 *
	 * @return the group ID of this cp definition link
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this cp definition link.
	 *
	 * @param groupId the group ID of this cp definition link
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this cp definition link.
	 *
	 * @return the company ID of this cp definition link
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp definition link.
	 *
	 * @param companyId the company ID of this cp definition link
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp definition link.
	 *
	 * @return the user ID of this cp definition link
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp definition link.
	 *
	 * @param userId the user ID of this cp definition link
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp definition link.
	 *
	 * @return the user uuid of this cp definition link
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp definition link.
	 *
	 * @param userUuid the user uuid of this cp definition link
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp definition link.
	 *
	 * @return the user name of this cp definition link
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp definition link.
	 *
	 * @param userName the user name of this cp definition link
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp definition link.
	 *
	 * @return the create date of this cp definition link
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp definition link.
	 *
	 * @param createDate the create date of this cp definition link
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp definition link.
	 *
	 * @return the modified date of this cp definition link
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp definition link.
	 *
	 * @param modifiedDate the modified date of this cp definition link
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp definition ID of this cp definition link.
	 *
	 * @return the cp definition ID of this cp definition link
	 */
	public long getCPDefinitionId();

	/**
	 * Sets the cp definition ID of this cp definition link.
	 *
	 * @param CPDefinitionId the cp definition ID of this cp definition link
	 */
	public void setCPDefinitionId(long CPDefinitionId);

	/**
	 * Returns the c product ID of this cp definition link.
	 *
	 * @return the c product ID of this cp definition link
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this cp definition link.
	 *
	 * @param CProductId the c product ID of this cp definition link
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the priority of this cp definition link.
	 *
	 * @return the priority of this cp definition link
	 */
	public double getPriority();

	/**
	 * Sets the priority of this cp definition link.
	 *
	 * @param priority the priority of this cp definition link
	 */
	public void setPriority(double priority);

	/**
	 * Returns the type of this cp definition link.
	 *
	 * @return the type of this cp definition link
	 */
	@AutoEscape
	public String getType();

	/**
	 * Sets the type of this cp definition link.
	 *
	 * @param type the type of this cp definition link
	 */
	public void setType(String type);

	@Override
	public CPDefinitionLink cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}