/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.model.wrapper.BaseModelWrapper;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * This class is a wrapper for {@link ResourceAction}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ResourceAction
 * @generated
 */
public class ResourceActionWrapper
	extends BaseModelWrapper<ResourceAction>
	implements ModelWrapper<ResourceAction>, ResourceAction {

	public ResourceActionWrapper(ResourceAction resourceAction) {
		super(resourceAction);
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("mvccVersion", getMvccVersion());
		attributes.put("resourceActionId", getResourceActionId());
		attributes.put("name", getName());
		attributes.put("actionId", getActionId());
		attributes.put("bitwiseValue", getBitwiseValue());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long mvccVersion = (Long)attributes.get("mvccVersion");

		if (mvccVersion != null) {
			setMvccVersion(mvccVersion);
		}

		Long resourceActionId = (Long)attributes.get("resourceActionId");

		if (resourceActionId != null) {
			setResourceActionId(resourceActionId);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String actionId = (String)attributes.get("actionId");

		if (actionId != null) {
			setActionId(actionId);
		}

		Long bitwiseValue = (Long)attributes.get("bitwiseValue");

		if (bitwiseValue != null) {
			setBitwiseValue(bitwiseValue);
		}
	}

	@Override
	public ResourceAction cloneWithOriginalValues() {
		return wrap(model.cloneWithOriginalValues());
	}

	/**
	 * Returns the action ID of this resource action.
	 *
	 * @return the action ID of this resource action
	 */
	@Override
	public String getActionId() {
		return model.getActionId();
	}

	/**
	 * Returns the bitwise value of this resource action.
	 *
	 * @return the bitwise value of this resource action
	 */
	@Override
	public long getBitwiseValue() {
		return model.getBitwiseValue();
	}

	/**
	 * Returns the mvcc version of this resource action.
	 *
	 * @return the mvcc version of this resource action
	 */
	@Override
	public long getMvccVersion() {
		return model.getMvccVersion();
	}

	/**
	 * Returns the name of this resource action.
	 *
	 * @return the name of this resource action
	 */
	@Override
	public String getName() {
		return model.getName();
	}

	/**
	 * Returns the primary key of this resource action.
	 *
	 * @return the primary key of this resource action
	 */
	@Override
	public long getPrimaryKey() {
		return model.getPrimaryKey();
	}

	/**
	 * Returns the resource action ID of this resource action.
	 *
	 * @return the resource action ID of this resource action
	 */
	@Override
	public long getResourceActionId() {
		return model.getResourceActionId();
	}

	@Override
	public void persist() {
		model.persist();
	}

	/**
	 * Sets the action ID of this resource action.
	 *
	 * @param actionId the action ID of this resource action
	 */
	@Override
	public void setActionId(String actionId) {
		model.setActionId(actionId);
	}

	/**
	 * Sets the bitwise value of this resource action.
	 *
	 * @param bitwiseValue the bitwise value of this resource action
	 */
	@Override
	public void setBitwiseValue(long bitwiseValue) {
		model.setBitwiseValue(bitwiseValue);
	}

	/**
	 * Sets the mvcc version of this resource action.
	 *
	 * @param mvccVersion the mvcc version of this resource action
	 */
	@Override
	public void setMvccVersion(long mvccVersion) {
		model.setMvccVersion(mvccVersion);
	}

	/**
	 * Sets the name of this resource action.
	 *
	 * @param name the name of this resource action
	 */
	@Override
	public void setName(String name) {
		model.setName(name);
	}

	/**
	 * Sets the primary key of this resource action.
	 *
	 * @param primaryKey the primary key of this resource action
	 */
	@Override
	public void setPrimaryKey(long primaryKey) {
		model.setPrimaryKey(primaryKey);
	}

	/**
	 * Sets the resource action ID of this resource action.
	 *
	 * @param resourceActionId the resource action ID of this resource action
	 */
	@Override
	public void setResourceActionId(long resourceActionId) {
		model.setResourceActionId(resourceActionId);
	}

	@Override
	public String toXmlString() {
		return model.toXmlString();
	}

	@Override
	protected ResourceActionWrapper wrap(ResourceAction resourceAction) {
		return new ResourceActionWrapper(resourceAction);
	}

}