/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.model.VirtualHostModel;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the VirtualHost service. Represents a row in the &quot;VirtualHost&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>VirtualHostModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link VirtualHostImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see VirtualHostImpl
 * @generated
 */
public class VirtualHostModelImpl
	extends BaseModelImpl<VirtualHost> implements VirtualHostModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a virtual host model instance should use the <code>VirtualHost</code> interface instead.
	 */
	public static final String TABLE_NAME = "VirtualHost";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"virtualHostId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"layoutSetId", Types.BIGINT}, {"hostname", Types.VARCHAR},
		{"defaultVirtualHost", Types.BOOLEAN}, {"languageId", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("virtualHostId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("layoutSetId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("hostname", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultVirtualHost", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("languageId", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table VirtualHost (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,virtualHostId LONG not null,companyId LONG,layoutSetId LONG,hostname VARCHAR(200) null,defaultVirtualHost BOOLEAN,languageId VARCHAR(75) null,primary key (virtualHostId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table VirtualHost";

	public static final String ORDER_BY_JPQL =
		" ORDER BY virtualHost.virtualHostId DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY VirtualHost.virtualHostId DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTVIRTUALHOST_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long HOSTNAME_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTSETID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VIRTUALHOSTID_COLUMN_BITMASK = 16L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.VirtualHost"));

	public VirtualHostModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _virtualHostId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setVirtualHostId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _virtualHostId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return VirtualHost.class;
	}

	@Override
	public String getModelClassName() {
		return VirtualHost.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<VirtualHost, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<VirtualHost, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<VirtualHost, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((VirtualHost)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<VirtualHost, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<VirtualHost, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(VirtualHost)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<VirtualHost, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<VirtualHost, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<VirtualHost, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<VirtualHost, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<VirtualHost, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", VirtualHost::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", VirtualHost::getCtCollectionId);
			attributeGetterFunctions.put(
				"virtualHostId", VirtualHost::getVirtualHostId);
			attributeGetterFunctions.put(
				"companyId", VirtualHost::getCompanyId);
			attributeGetterFunctions.put(
				"layoutSetId", VirtualHost::getLayoutSetId);
			attributeGetterFunctions.put("hostname", VirtualHost::getHostname);
			attributeGetterFunctions.put(
				"defaultVirtualHost", VirtualHost::getDefaultVirtualHost);
			attributeGetterFunctions.put(
				"languageId", VirtualHost::getLanguageId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<VirtualHost, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<VirtualHost, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<VirtualHost, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<VirtualHost, Long>)VirtualHost::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<VirtualHost, Long>)VirtualHost::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"virtualHostId",
				(BiConsumer<VirtualHost, Long>)VirtualHost::setVirtualHostId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<VirtualHost, Long>)VirtualHost::setCompanyId);
			attributeSetterBiConsumers.put(
				"layoutSetId",
				(BiConsumer<VirtualHost, Long>)VirtualHost::setLayoutSetId);
			attributeSetterBiConsumers.put(
				"hostname",
				(BiConsumer<VirtualHost, String>)VirtualHost::setHostname);
			attributeSetterBiConsumers.put(
				"defaultVirtualHost",
				(BiConsumer<VirtualHost, Boolean>)
					VirtualHost::setDefaultVirtualHost);
			attributeSetterBiConsumers.put(
				"languageId",
				(BiConsumer<VirtualHost, String>)VirtualHost::setLanguageId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public long getVirtualHostId() {
		return _virtualHostId;
	}

	@Override
	public void setVirtualHostId(long virtualHostId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_virtualHostId = virtualHostId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getLayoutSetId() {
		return _layoutSetId;
	}

	@Override
	public void setLayoutSetId(long layoutSetId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutSetId = layoutSetId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalLayoutSetId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("layoutSetId"));
	}

	@Override
	public String getHostname() {
		if (_hostname == null) {
			return "";
		}
		else {
			return _hostname;
		}
	}

	@Override
	public void setHostname(String hostname) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_hostname = hostname;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalHostname() {
		return getColumnOriginalValue("hostname");
	}

	@Override
	public boolean getDefaultVirtualHost() {
		return _defaultVirtualHost;
	}

	@Override
	public boolean isDefaultVirtualHost() {
		return _defaultVirtualHost;
	}

	@Override
	public void setDefaultVirtualHost(boolean defaultVirtualHost) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultVirtualHost = defaultVirtualHost;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultVirtualHost() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultVirtualHost"));
	}

	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return "";
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_languageId = languageId;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), VirtualHost.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public VirtualHost toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, VirtualHost>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		VirtualHostImpl virtualHostImpl = new VirtualHostImpl();

		virtualHostImpl.setMvccVersion(getMvccVersion());
		virtualHostImpl.setCtCollectionId(getCtCollectionId());
		virtualHostImpl.setVirtualHostId(getVirtualHostId());
		virtualHostImpl.setCompanyId(getCompanyId());
		virtualHostImpl.setLayoutSetId(getLayoutSetId());
		virtualHostImpl.setHostname(getHostname());
		virtualHostImpl.setDefaultVirtualHost(isDefaultVirtualHost());
		virtualHostImpl.setLanguageId(getLanguageId());

		virtualHostImpl.resetOriginalValues();

		return virtualHostImpl;
	}

	@Override
	public VirtualHost cloneWithOriginalValues() {
		VirtualHostImpl virtualHostImpl = new VirtualHostImpl();

		virtualHostImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		virtualHostImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		virtualHostImpl.setVirtualHostId(
			this.<Long>getColumnOriginalValue("virtualHostId"));
		virtualHostImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		virtualHostImpl.setLayoutSetId(
			this.<Long>getColumnOriginalValue("layoutSetId"));
		virtualHostImpl.setHostname(
			this.<String>getColumnOriginalValue("hostname"));
		virtualHostImpl.setDefaultVirtualHost(
			this.<Boolean>getColumnOriginalValue("defaultVirtualHost"));
		virtualHostImpl.setLanguageId(
			this.<String>getColumnOriginalValue("languageId"));

		return virtualHostImpl;
	}

	@Override
	public int compareTo(VirtualHost virtualHost) {
		int value = 0;

		if (getVirtualHostId() < virtualHost.getVirtualHostId()) {
			value = -1;
		}
		else if (getVirtualHostId() > virtualHost.getVirtualHostId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof VirtualHost)) {
			return false;
		}

		VirtualHost virtualHost = (VirtualHost)object;

		long primaryKey = virtualHost.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<VirtualHost> toCacheModel() {
		VirtualHostCacheModel virtualHostCacheModel =
			new VirtualHostCacheModel();

		virtualHostCacheModel.mvccVersion = getMvccVersion();

		virtualHostCacheModel.ctCollectionId = getCtCollectionId();

		virtualHostCacheModel.virtualHostId = getVirtualHostId();

		virtualHostCacheModel.companyId = getCompanyId();

		virtualHostCacheModel.layoutSetId = getLayoutSetId();

		virtualHostCacheModel.hostname = getHostname();

		String hostname = virtualHostCacheModel.hostname;

		if ((hostname != null) && (hostname.length() == 0)) {
			virtualHostCacheModel.hostname = null;
		}

		virtualHostCacheModel.defaultVirtualHost = isDefaultVirtualHost();

		virtualHostCacheModel.languageId = getLanguageId();

		String languageId = virtualHostCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			virtualHostCacheModel.languageId = null;
		}

		return virtualHostCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<VirtualHost, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<VirtualHost, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<VirtualHost, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((VirtualHost)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, VirtualHost>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					VirtualHost.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private long _virtualHostId;
	private long _companyId;
	private long _layoutSetId;
	private String _hostname;
	private boolean _defaultVirtualHost;
	private String _languageId;

	public <T> T getColumnValue(String columnName) {
		Function<VirtualHost, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((VirtualHost)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("virtualHostId", _virtualHostId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("layoutSetId", _layoutSetId);
		_columnOriginalValues.put("hostname", _hostname);
		_columnOriginalValues.put("defaultVirtualHost", _defaultVirtualHost);
		_columnOriginalValues.put("languageId", _languageId);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("virtualHostId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("layoutSetId", 16L);

		columnBitmasks.put("hostname", 32L);

		columnBitmasks.put("defaultVirtualHost", 64L);

		columnBitmasks.put("languageId", 128L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private VirtualHost _escapedModel;

}