/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.adaptive.media.image.finder;

import com.liferay.adaptive.media.finder.AMFinder;
import com.liferay.adaptive.media.processor.AMProcessor;
import com.liferay.portal.kernel.repository.model.FileVersion;

/**
 * Provides a specialized interface for locating {@link
 * com.liferay.adaptive.media.AdaptiveMedia} specific {@link FileVersion} models
 * generated by {@link AMProcessor}s. Implementations must accept queries
 * generated by {@link AMImageQueryBuilder} instances.
 *
 * @author Adolfo Pérez
 */
public interface AMImageFinder
	extends AMFinder
		<AMImageQueryBuilder, FileVersion, AMProcessor<FileVersion>> {
}