/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.asset.category.property.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the AssetCategoryProperty service. Represents a row in the &quot;AssetCategoryProperty&quot; database table, with each column mapped to a property of this class.
 *
 * @author Brian Wing Shun Chan
 * @see AssetCategoryPropertyModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.asset.category.property.model.impl.AssetCategoryPropertyImpl"
)
@ProviderType
public interface AssetCategoryProperty
	extends AssetCategoryPropertyModel, PersistedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.asset.category.property.model.impl.AssetCategoryPropertyImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<AssetCategoryProperty, Long>
		CATEGORY_PROPERTY_ID_ACCESSOR =
			new Accessor<AssetCategoryProperty, Long>() {

				@Override
				public Long get(AssetCategoryProperty assetCategoryProperty) {
					return assetCategoryProperty.getCategoryPropertyId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<AssetCategoryProperty> getTypeClass() {
					return AssetCategoryProperty.class;
				}

			};

}