/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTCollectionTemplate service. Represents a row in the &quot;CTCollectionTemplate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.model.impl.CTCollectionTemplateModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.model.impl.CTCollectionTemplateImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTCollectionTemplate
 * @generated
 */
@ProviderType
public interface CTCollectionTemplateModel
	extends BaseModel<CTCollectionTemplate>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ct collection template model instance should use the {@link CTCollectionTemplate} interface instead.
	 */

	/**
	 * Returns the primary key of this ct collection template.
	 *
	 * @return the primary key of this ct collection template
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ct collection template.
	 *
	 * @param primaryKey the primary key of this ct collection template
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ct collection template.
	 *
	 * @return the mvcc version of this ct collection template
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ct collection template.
	 *
	 * @param mvccVersion the mvcc version of this ct collection template
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection template ID of this ct collection template.
	 *
	 * @return the ct collection template ID of this ct collection template
	 */
	public long getCtCollectionTemplateId();

	/**
	 * Sets the ct collection template ID of this ct collection template.
	 *
	 * @param ctCollectionTemplateId the ct collection template ID of this ct collection template
	 */
	public void setCtCollectionTemplateId(long ctCollectionTemplateId);

	/**
	 * Returns the company ID of this ct collection template.
	 *
	 * @return the company ID of this ct collection template
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ct collection template.
	 *
	 * @param companyId the company ID of this ct collection template
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this ct collection template.
	 *
	 * @return the user ID of this ct collection template
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this ct collection template.
	 *
	 * @param userId the user ID of this ct collection template
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this ct collection template.
	 *
	 * @return the user uuid of this ct collection template
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this ct collection template.
	 *
	 * @param userUuid the user uuid of this ct collection template
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this ct collection template.
	 *
	 * @return the create date of this ct collection template
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this ct collection template.
	 *
	 * @param createDate the create date of this ct collection template
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this ct collection template.
	 *
	 * @return the modified date of this ct collection template
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this ct collection template.
	 *
	 * @param modifiedDate the modified date of this ct collection template
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the name of this ct collection template.
	 *
	 * @return the name of this ct collection template
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this ct collection template.
	 *
	 * @param name the name of this ct collection template
	 */
	public void setName(String name);

	/**
	 * Returns the description of this ct collection template.
	 *
	 * @return the description of this ct collection template
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this ct collection template.
	 *
	 * @param description the description of this ct collection template
	 */
	public void setDescription(String description);

	@Override
	public CTCollectionTemplate cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}