/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.store.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.sql.Blob;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTSContent service. Represents a row in the &quot;CTSContent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.store.model.impl.CTSContentModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.store.model.impl.CTSContentImpl</code>.
 * </p>
 *
 * @author Shuyang Zhou
 * @see CTSContent
 * @generated
 */
@ProviderType
public interface CTSContentModel
	extends BaseModel<CTSContent>, CTModel<CTSContent>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cts content model instance should use the {@link CTSContent} interface instead.
	 */

	/**
	 * Returns the primary key of this cts content.
	 *
	 * @return the primary key of this cts content
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cts content.
	 *
	 * @param primaryKey the primary key of this cts content
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this cts content.
	 *
	 * @return the mvcc version of this cts content
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this cts content.
	 *
	 * @param mvccVersion the mvcc version of this cts content
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this cts content.
	 *
	 * @return the ct collection ID of this cts content
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this cts content.
	 *
	 * @param ctCollectionId the ct collection ID of this cts content
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the cts content ID of this cts content.
	 *
	 * @return the cts content ID of this cts content
	 */
	public long getCtsContentId();

	/**
	 * Sets the cts content ID of this cts content.
	 *
	 * @param ctsContentId the cts content ID of this cts content
	 */
	public void setCtsContentId(long ctsContentId);

	/**
	 * Returns the company ID of this cts content.
	 *
	 * @return the company ID of this cts content
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cts content.
	 *
	 * @param companyId the company ID of this cts content
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the repository ID of this cts content.
	 *
	 * @return the repository ID of this cts content
	 */
	public long getRepositoryId();

	/**
	 * Sets the repository ID of this cts content.
	 *
	 * @param repositoryId the repository ID of this cts content
	 */
	public void setRepositoryId(long repositoryId);

	/**
	 * Returns the path of this cts content.
	 *
	 * @return the path of this cts content
	 */
	@AutoEscape
	public String getPath();

	/**
	 * Sets the path of this cts content.
	 *
	 * @param path the path of this cts content
	 */
	public void setPath(String path);

	/**
	 * Returns the version of this cts content.
	 *
	 * @return the version of this cts content
	 */
	@AutoEscape
	public String getVersion();

	/**
	 * Sets the version of this cts content.
	 *
	 * @param version the version of this cts content
	 */
	public void setVersion(String version);

	/**
	 * Returns the data of this cts content.
	 *
	 * @return the data of this cts content
	 */
	public Blob getData();

	/**
	 * Sets the data of this cts content.
	 *
	 * @param data the data of this cts content
	 */
	public void setData(Blob data);

	/**
	 * Returns the size of this cts content.
	 *
	 * @return the size of this cts content
	 */
	public long getSize();

	/**
	 * Sets the size of this cts content.
	 *
	 * @param size the size of this cts content
	 */
	public void setSize(long size);

	/**
	 * Returns the store type of this cts content.
	 *
	 * @return the store type of this cts content
	 */
	@AutoEscape
	public String getStoreType();

	/**
	 * Sets the store type of this cts content.
	 *
	 * @param storeType the store type of this cts content
	 */
	public void setStoreType(String storeType);

	@Override
	public CTSContent cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}