/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.product.type.grouped.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CPDefinitionGroupedEntry service. Represents a row in the &quot;CPDefinitionGroupedEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.product.type.grouped.model.impl.CPDefinitionGroupedEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.product.type.grouped.model.impl.CPDefinitionGroupedEntryImpl</code>.
 * </p>
 *
 * @author Andrea Di Giorgi
 * @see CPDefinitionGroupedEntry
 * @generated
 */
@ProviderType
public interface CPDefinitionGroupedEntryModel
	extends BaseModel<CPDefinitionGroupedEntry>, GroupedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a cp definition grouped entry model instance should use the {@link CPDefinitionGroupedEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this cp definition grouped entry.
	 *
	 * @return the primary key of this cp definition grouped entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this cp definition grouped entry.
	 *
	 * @param primaryKey the primary key of this cp definition grouped entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this cp definition grouped entry.
	 *
	 * @return the mvcc version of this cp definition grouped entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this cp definition grouped entry.
	 *
	 * @param mvccVersion the mvcc version of this cp definition grouped entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this cp definition grouped entry.
	 *
	 * @return the uuid of this cp definition grouped entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this cp definition grouped entry.
	 *
	 * @param uuid the uuid of this cp definition grouped entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the cp definition grouped entry ID of this cp definition grouped entry.
	 *
	 * @return the cp definition grouped entry ID of this cp definition grouped entry
	 */
	public long getCPDefinitionGroupedEntryId();

	/**
	 * Sets the cp definition grouped entry ID of this cp definition grouped entry.
	 *
	 * @param CPDefinitionGroupedEntryId the cp definition grouped entry ID of this cp definition grouped entry
	 */
	public void setCPDefinitionGroupedEntryId(long CPDefinitionGroupedEntryId);

	/**
	 * Returns the group ID of this cp definition grouped entry.
	 *
	 * @return the group ID of this cp definition grouped entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this cp definition grouped entry.
	 *
	 * @param groupId the group ID of this cp definition grouped entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this cp definition grouped entry.
	 *
	 * @return the company ID of this cp definition grouped entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this cp definition grouped entry.
	 *
	 * @param companyId the company ID of this cp definition grouped entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this cp definition grouped entry.
	 *
	 * @return the user ID of this cp definition grouped entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this cp definition grouped entry.
	 *
	 * @param userId the user ID of this cp definition grouped entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this cp definition grouped entry.
	 *
	 * @return the user uuid of this cp definition grouped entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this cp definition grouped entry.
	 *
	 * @param userUuid the user uuid of this cp definition grouped entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this cp definition grouped entry.
	 *
	 * @return the user name of this cp definition grouped entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this cp definition grouped entry.
	 *
	 * @param userName the user name of this cp definition grouped entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this cp definition grouped entry.
	 *
	 * @return the create date of this cp definition grouped entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this cp definition grouped entry.
	 *
	 * @param createDate the create date of this cp definition grouped entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this cp definition grouped entry.
	 *
	 * @return the modified date of this cp definition grouped entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this cp definition grouped entry.
	 *
	 * @param modifiedDate the modified date of this cp definition grouped entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the cp definition ID of this cp definition grouped entry.
	 *
	 * @return the cp definition ID of this cp definition grouped entry
	 */
	public long getCPDefinitionId();

	/**
	 * Sets the cp definition ID of this cp definition grouped entry.
	 *
	 * @param CPDefinitionId the cp definition ID of this cp definition grouped entry
	 */
	public void setCPDefinitionId(long CPDefinitionId);

	/**
	 * Returns the entry c product ID of this cp definition grouped entry.
	 *
	 * @return the entry c product ID of this cp definition grouped entry
	 */
	public long getEntryCProductId();

	/**
	 * Sets the entry c product ID of this cp definition grouped entry.
	 *
	 * @param entryCProductId the entry c product ID of this cp definition grouped entry
	 */
	public void setEntryCProductId(long entryCProductId);

	/**
	 * Returns the priority of this cp definition grouped entry.
	 *
	 * @return the priority of this cp definition grouped entry
	 */
	public double getPriority();

	/**
	 * Sets the priority of this cp definition grouped entry.
	 *
	 * @param priority the priority of this cp definition grouped entry
	 */
	public void setPriority(double priority);

	/**
	 * Returns the quantity of this cp definition grouped entry.
	 *
	 * @return the quantity of this cp definition grouped entry
	 */
	public int getQuantity();

	/**
	 * Sets the quantity of this cp definition grouped entry.
	 *
	 * @param quantity the quantity of this cp definition grouped entry
	 */
	public void setQuantity(int quantity);

	@Override
	public CPDefinitionGroupedEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}