/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.shipping.engine.fixed.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceShippingFixedOptionQualifier service. Represents a row in the &quot;CSFixedOptionQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.shipping.engine.fixed.model.impl.CommerceShippingFixedOptionQualifierModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.shipping.engine.fixed.model.impl.CommerceShippingFixedOptionQualifierImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingFixedOptionQualifier
 * @generated
 */
@ProviderType
public interface CommerceShippingFixedOptionQualifierModel
	extends AttachedModel, AuditedModel,
			BaseModel<CommerceShippingFixedOptionQualifier>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce shipping fixed option qualifier model instance should use the {@link CommerceShippingFixedOptionQualifier} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce shipping fixed option qualifier.
	 *
	 * @return the primary key of this commerce shipping fixed option qualifier
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce shipping fixed option qualifier.
	 *
	 * @param primaryKey the primary key of this commerce shipping fixed option qualifier
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce shipping fixed option qualifier.
	 *
	 * @return the mvcc version of this commerce shipping fixed option qualifier
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce shipping fixed option qualifier.
	 *
	 * @param mvccVersion the mvcc version of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the commerce shipping fixed option qualifier ID of this commerce shipping fixed option qualifier.
	 *
	 * @return the commerce shipping fixed option qualifier ID of this commerce shipping fixed option qualifier
	 */
	public long getCommerceShippingFixedOptionQualifierId();

	/**
	 * Sets the commerce shipping fixed option qualifier ID of this commerce shipping fixed option qualifier.
	 *
	 * @param commerceShippingFixedOptionQualifierId the commerce shipping fixed option qualifier ID of this commerce shipping fixed option qualifier
	 */
	public void setCommerceShippingFixedOptionQualifierId(
		long commerceShippingFixedOptionQualifierId);

	/**
	 * Returns the company ID of this commerce shipping fixed option qualifier.
	 *
	 * @return the company ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce shipping fixed option qualifier.
	 *
	 * @param companyId the company ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce shipping fixed option qualifier.
	 *
	 * @return the user ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce shipping fixed option qualifier.
	 *
	 * @param userId the user ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce shipping fixed option qualifier.
	 *
	 * @return the user uuid of this commerce shipping fixed option qualifier
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce shipping fixed option qualifier.
	 *
	 * @param userUuid the user uuid of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce shipping fixed option qualifier.
	 *
	 * @return the user name of this commerce shipping fixed option qualifier
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce shipping fixed option qualifier.
	 *
	 * @param userName the user name of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce shipping fixed option qualifier.
	 *
	 * @return the create date of this commerce shipping fixed option qualifier
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce shipping fixed option qualifier.
	 *
	 * @param createDate the create date of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce shipping fixed option qualifier.
	 *
	 * @return the modified date of this commerce shipping fixed option qualifier
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce shipping fixed option qualifier.
	 *
	 * @param modifiedDate the modified date of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fully qualified class name of this commerce shipping fixed option qualifier.
	 *
	 * @return the fully qualified class name of this commerce shipping fixed option qualifier
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this commerce shipping fixed option qualifier.
	 *
	 * @return the class name ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this commerce shipping fixed option qualifier.
	 *
	 * @param classNameId the class name ID of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this commerce shipping fixed option qualifier.
	 *
	 * @return the class pk of this commerce shipping fixed option qualifier
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this commerce shipping fixed option qualifier.
	 *
	 * @param classPK the class pk of this commerce shipping fixed option qualifier
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the commerce shipping fixed option ID of this commerce shipping fixed option qualifier.
	 *
	 * @return the commerce shipping fixed option ID of this commerce shipping fixed option qualifier
	 */
	public long getCommerceShippingFixedOptionId();

	/**
	 * Sets the commerce shipping fixed option ID of this commerce shipping fixed option qualifier.
	 *
	 * @param commerceShippingFixedOptionId the commerce shipping fixed option ID of this commerce shipping fixed option qualifier
	 */
	public void setCommerceShippingFixedOptionId(
		long commerceShippingFixedOptionId);

	@Override
	public CommerceShippingFixedOptionQualifier cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}