/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.data.engine.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DEDataDefinitionFieldLink service. Represents a row in the &quot;DEDataDefinitionFieldLink&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.data.engine.model.impl.DEDataDefinitionFieldLinkModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.data.engine.model.impl.DEDataDefinitionFieldLinkImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DEDataDefinitionFieldLink
 * @generated
 */
@ProviderType
public interface DEDataDefinitionFieldLinkModel
	extends AttachedModel, BaseModel<DEDataDefinitionFieldLink>,
			CTModel<DEDataDefinitionFieldLink>, MVCCModel, ShardedModel,
			StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a de data definition field link model instance should use the {@link DEDataDefinitionFieldLink} interface instead.
	 */

	/**
	 * Returns the primary key of this de data definition field link.
	 *
	 * @return the primary key of this de data definition field link
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this de data definition field link.
	 *
	 * @param primaryKey the primary key of this de data definition field link
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this de data definition field link.
	 *
	 * @return the mvcc version of this de data definition field link
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this de data definition field link.
	 *
	 * @param mvccVersion the mvcc version of this de data definition field link
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this de data definition field link.
	 *
	 * @return the ct collection ID of this de data definition field link
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this de data definition field link.
	 *
	 * @param ctCollectionId the ct collection ID of this de data definition field link
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this de data definition field link.
	 *
	 * @return the uuid of this de data definition field link
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this de data definition field link.
	 *
	 * @param uuid the uuid of this de data definition field link
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the de data definition field link ID of this de data definition field link.
	 *
	 * @return the de data definition field link ID of this de data definition field link
	 */
	public long getDeDataDefinitionFieldLinkId();

	/**
	 * Sets the de data definition field link ID of this de data definition field link.
	 *
	 * @param deDataDefinitionFieldLinkId the de data definition field link ID of this de data definition field link
	 */
	public void setDeDataDefinitionFieldLinkId(
		long deDataDefinitionFieldLinkId);

	/**
	 * Returns the group ID of this de data definition field link.
	 *
	 * @return the group ID of this de data definition field link
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this de data definition field link.
	 *
	 * @param groupId the group ID of this de data definition field link
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this de data definition field link.
	 *
	 * @return the company ID of this de data definition field link
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this de data definition field link.
	 *
	 * @param companyId the company ID of this de data definition field link
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this de data definition field link.
	 *
	 * @return the create date of this de data definition field link
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this de data definition field link.
	 *
	 * @param createDate the create date of this de data definition field link
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this de data definition field link.
	 *
	 * @return the modified date of this de data definition field link
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this de data definition field link.
	 *
	 * @param modifiedDate the modified date of this de data definition field link
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fully qualified class name of this de data definition field link.
	 *
	 * @return the fully qualified class name of this de data definition field link
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this de data definition field link.
	 *
	 * @return the class name ID of this de data definition field link
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this de data definition field link.
	 *
	 * @param classNameId the class name ID of this de data definition field link
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this de data definition field link.
	 *
	 * @return the class pk of this de data definition field link
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this de data definition field link.
	 *
	 * @param classPK the class pk of this de data definition field link
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the ddm structure ID of this de data definition field link.
	 *
	 * @return the ddm structure ID of this de data definition field link
	 */
	public long getDdmStructureId();

	/**
	 * Sets the ddm structure ID of this de data definition field link.
	 *
	 * @param ddmStructureId the ddm structure ID of this de data definition field link
	 */
	public void setDdmStructureId(long ddmStructureId);

	/**
	 * Returns the field name of this de data definition field link.
	 *
	 * @return the field name of this de data definition field link
	 */
	@AutoEscape
	public String getFieldName();

	/**
	 * Sets the field name of this de data definition field link.
	 *
	 * @param fieldName the field name of this de data definition field link
	 */
	public void setFieldName(String fieldName);

	/**
	 * Returns the last publish date of this de data definition field link.
	 *
	 * @return the last publish date of this de data definition field link
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this de data definition field link.
	 *
	 * @param lastPublishDate the last publish date of this de data definition field link
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public DEDataDefinitionFieldLink cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}