/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.lists.constants;

/**
 * Holds action key constants used in the DDL permission system.
 *
 * @author Rafael Praxedes
 */
public class DDLActionKeys {

	/**
	 * {@value #ADD_RECORD} is the action key to use to check permissions for
	 * adding a record.
	 */
	public static final String ADD_RECORD = "ADD_RECORD";

	/**
	 * {@value #ADD_RECORD_SET} is the action key to use to check permissions
	 * for adding record sets.
	 */
	public static final String ADD_RECORD_SET = "ADD_RECORD_SET";

}