/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.fragment.util.comparator;

import com.liferay.fragment.model.FragmentComposition;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.Date;

/**
 * @author Pavel Savinov
 */
public class FragmentCompositionFragmentEntryCreateDateComparator
	extends OrderByComparator<Object> {

	public static final String ORDER_BY_ASC = "createDate ASC";

	public static final String ORDER_BY_DESC = "createDate DESC";

	public static final String[] ORDER_BY_FIELDS = {"createDate"};

	public FragmentCompositionFragmentEntryCreateDateComparator() {
		this(true);
	}

	public FragmentCompositionFragmentEntryCreateDateComparator(
		boolean ascending) {

		_ascending = ascending;
	}

	@Override
	public int compare(Object object1, Object object2) {
		int value = DateUtil.compareTo(
			getCreateDate(object1), getCreateDate(object2));

		if (_ascending) {
			return value;
		}

		return -value;
	}

	@Override
	public String getOrderBy() {
		if (_ascending) {
			return ORDER_BY_ASC;
		}

		return ORDER_BY_DESC;
	}

	@Override
	public String[] getOrderByFields() {
		return ORDER_BY_FIELDS;
	}

	@Override
	public boolean isAscending() {
		return _ascending;
	}

	protected Date getCreateDate(Object object) {
		if (object instanceof FragmentComposition) {
			FragmentComposition fragmentComposition =
				(FragmentComposition)object;

			return fragmentComposition.getCreateDate();
		}

		FragmentEntry fragmentEntry = (FragmentEntry)object;

		return fragmentEntry.getCreateDate();
	}

	private final boolean _ascending;

}