/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the NotificationQueueEntryAttachment service. Represents a row in the &quot;NQueueEntryAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.notification.model.impl.NotificationQueueEntryAttachmentModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.notification.model.impl.NotificationQueueEntryAttachmentImpl</code>.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationQueueEntryAttachment
 * @generated
 */
@ProviderType
public interface NotificationQueueEntryAttachmentModel
	extends BaseModel<NotificationQueueEntryAttachment>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a notification queue entry attachment model instance should use the {@link NotificationQueueEntryAttachment} interface instead.
	 */

	/**
	 * Returns the primary key of this notification queue entry attachment.
	 *
	 * @return the primary key of this notification queue entry attachment
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this notification queue entry attachment.
	 *
	 * @param primaryKey the primary key of this notification queue entry attachment
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this notification queue entry attachment.
	 *
	 * @return the mvcc version of this notification queue entry attachment
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this notification queue entry attachment.
	 *
	 * @param mvccVersion the mvcc version of this notification queue entry attachment
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the notification queue entry attachment ID of this notification queue entry attachment.
	 *
	 * @return the notification queue entry attachment ID of this notification queue entry attachment
	 */
	public long getNotificationQueueEntryAttachmentId();

	/**
	 * Sets the notification queue entry attachment ID of this notification queue entry attachment.
	 *
	 * @param notificationQueueEntryAttachmentId the notification queue entry attachment ID of this notification queue entry attachment
	 */
	public void setNotificationQueueEntryAttachmentId(
		long notificationQueueEntryAttachmentId);

	/**
	 * Returns the company ID of this notification queue entry attachment.
	 *
	 * @return the company ID of this notification queue entry attachment
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this notification queue entry attachment.
	 *
	 * @param companyId the company ID of this notification queue entry attachment
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the file entry ID of this notification queue entry attachment.
	 *
	 * @return the file entry ID of this notification queue entry attachment
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this notification queue entry attachment.
	 *
	 * @param fileEntryId the file entry ID of this notification queue entry attachment
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the notification queue entry ID of this notification queue entry attachment.
	 *
	 * @return the notification queue entry ID of this notification queue entry attachment
	 */
	public long getNotificationQueueEntryId();

	/**
	 * Sets the notification queue entry ID of this notification queue entry attachment.
	 *
	 * @param notificationQueueEntryId the notification queue entry ID of this notification queue entry attachment
	 */
	public void setNotificationQueueEntryId(long notificationQueueEntryId);

	@Override
	public NotificationQueueEntryAttachment cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}