/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;

import java.util.Date;
import java.util.Locale;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the NotificationRecipientSetting service. Represents a row in the &quot;NotificationRecipientSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.notification.model.impl.NotificationRecipientSettingModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.notification.model.impl.NotificationRecipientSettingImpl</code>.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationRecipientSetting
 * @generated
 */
@ProviderType
public interface NotificationRecipientSettingModel
	extends BaseModel<NotificationRecipientSetting>, LocalizedModel, MVCCModel,
			ShardedModel, StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a notification recipient setting model instance should use the {@link NotificationRecipientSetting} interface instead.
	 */

	/**
	 * Returns the primary key of this notification recipient setting.
	 *
	 * @return the primary key of this notification recipient setting
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this notification recipient setting.
	 *
	 * @param primaryKey the primary key of this notification recipient setting
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this notification recipient setting.
	 *
	 * @return the mvcc version of this notification recipient setting
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this notification recipient setting.
	 *
	 * @param mvccVersion the mvcc version of this notification recipient setting
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this notification recipient setting.
	 *
	 * @return the uuid of this notification recipient setting
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this notification recipient setting.
	 *
	 * @param uuid the uuid of this notification recipient setting
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the notification recipient setting ID of this notification recipient setting.
	 *
	 * @return the notification recipient setting ID of this notification recipient setting
	 */
	public long getNotificationRecipientSettingId();

	/**
	 * Sets the notification recipient setting ID of this notification recipient setting.
	 *
	 * @param notificationRecipientSettingId the notification recipient setting ID of this notification recipient setting
	 */
	public void setNotificationRecipientSettingId(
		long notificationRecipientSettingId);

	/**
	 * Returns the company ID of this notification recipient setting.
	 *
	 * @return the company ID of this notification recipient setting
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this notification recipient setting.
	 *
	 * @param companyId the company ID of this notification recipient setting
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this notification recipient setting.
	 *
	 * @return the user ID of this notification recipient setting
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this notification recipient setting.
	 *
	 * @param userId the user ID of this notification recipient setting
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this notification recipient setting.
	 *
	 * @return the user uuid of this notification recipient setting
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this notification recipient setting.
	 *
	 * @param userUuid the user uuid of this notification recipient setting
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this notification recipient setting.
	 *
	 * @return the user name of this notification recipient setting
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this notification recipient setting.
	 *
	 * @param userName the user name of this notification recipient setting
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this notification recipient setting.
	 *
	 * @return the create date of this notification recipient setting
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this notification recipient setting.
	 *
	 * @param createDate the create date of this notification recipient setting
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this notification recipient setting.
	 *
	 * @return the modified date of this notification recipient setting
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this notification recipient setting.
	 *
	 * @param modifiedDate the modified date of this notification recipient setting
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the notification recipient ID of this notification recipient setting.
	 *
	 * @return the notification recipient ID of this notification recipient setting
	 */
	public long getNotificationRecipientId();

	/**
	 * Sets the notification recipient ID of this notification recipient setting.
	 *
	 * @param notificationRecipientId the notification recipient ID of this notification recipient setting
	 */
	public void setNotificationRecipientId(long notificationRecipientId);

	/**
	 * Returns the name of this notification recipient setting.
	 *
	 * @return the name of this notification recipient setting
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this notification recipient setting.
	 *
	 * @param name the name of this notification recipient setting
	 */
	public void setName(String name);

	/**
	 * Returns the value of this notification recipient setting.
	 *
	 * @return the value of this notification recipient setting
	 */
	public String getValue();

	/**
	 * Returns the localized value of this notification recipient setting in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param locale the locale of the language
	 * @return the localized value of this notification recipient setting
	 */
	@AutoEscape
	public String getValue(Locale locale);

	/**
	 * Returns the localized value of this notification recipient setting in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param locale the local of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized value of this notification recipient setting. If <code>useDefault</code> is <code>false</code> and no localization exists for the requested language, an empty string will be returned.
	 */
	@AutoEscape
	public String getValue(Locale locale, boolean useDefault);

	/**
	 * Returns the localized value of this notification recipient setting in the language. Uses the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @return the localized value of this notification recipient setting
	 */
	@AutoEscape
	public String getValue(String languageId);

	/**
	 * Returns the localized value of this notification recipient setting in the language, optionally using the default language if no localization exists for the requested language.
	 *
	 * @param languageId the ID of the language
	 * @param useDefault whether to use the default language if no localization exists for the requested language
	 * @return the localized value of this notification recipient setting
	 */
	@AutoEscape
	public String getValue(String languageId, boolean useDefault);

	@AutoEscape
	public String getValueCurrentLanguageId();

	@AutoEscape
	public String getValueCurrentValue();

	/**
	 * Returns a map of the locales and localized values of this notification recipient setting.
	 *
	 * @return the locales and localized values of this notification recipient setting
	 */
	public Map<Locale, String> getValueMap();

	/**
	 * Sets the value of this notification recipient setting.
	 *
	 * @param value the value of this notification recipient setting
	 */
	public void setValue(String value);

	/**
	 * Sets the localized value of this notification recipient setting in the language.
	 *
	 * @param value the localized value of this notification recipient setting
	 * @param locale the locale of the language
	 */
	public void setValue(String value, Locale locale);

	/**
	 * Sets the localized value of this notification recipient setting in the language, and sets the default locale.
	 *
	 * @param value the localized value of this notification recipient setting
	 * @param locale the locale of the language
	 * @param defaultLocale the default locale
	 */
	public void setValue(String value, Locale locale, Locale defaultLocale);

	public void setValueCurrentLanguageId(String languageId);

	/**
	 * Sets the localized values of this notification recipient setting from the map of locales and localized values.
	 *
	 * @param valueMap the locales and localized values of this notification recipient setting
	 */
	public void setValueMap(Map<Locale, String> valueMap);

	/**
	 * Sets the localized values of this notification recipient setting from the map of locales and localized values, and sets the default locale.
	 *
	 * @param valueMap the locales and localized values of this notification recipient setting
	 * @param defaultLocale the default locale
	 */
	public void setValueMap(Map<Locale, String> valueMap, Locale defaultLocale);

	@Override
	public String[] getAvailableLanguageIds();

	@Override
	public String getDefaultLanguageId();

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException;

	@Override
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException;

	@Override
	public NotificationRecipientSetting cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}