/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth.client.persistence.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuthClientEntry service. Represents a row in the &quot;OAuthClientEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.oauth.client.persistence.model.impl.OAuthClientEntryModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.oauth.client.persistence.model.impl.OAuthClientEntryImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthClientEntry
 * @generated
 */
@ProviderType
public interface OAuthClientEntryModel
	extends AuditedModel, BaseModel<OAuthClientEntry>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth client entry model instance should use the {@link OAuthClientEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth client entry.
	 *
	 * @return the primary key of this o auth client entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth client entry.
	 *
	 * @param primaryKey the primary key of this o auth client entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this o auth client entry.
	 *
	 * @return the mvcc version of this o auth client entry
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this o auth client entry.
	 *
	 * @param mvccVersion the mvcc version of this o auth client entry
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the o auth client entry ID of this o auth client entry.
	 *
	 * @return the o auth client entry ID of this o auth client entry
	 */
	public long getOAuthClientEntryId();

	/**
	 * Sets the o auth client entry ID of this o auth client entry.
	 *
	 * @param oAuthClientEntryId the o auth client entry ID of this o auth client entry
	 */
	public void setOAuthClientEntryId(long oAuthClientEntryId);

	/**
	 * Returns the company ID of this o auth client entry.
	 *
	 * @return the company ID of this o auth client entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth client entry.
	 *
	 * @param companyId the company ID of this o auth client entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this o auth client entry.
	 *
	 * @return the user ID of this o auth client entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this o auth client entry.
	 *
	 * @param userId the user ID of this o auth client entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this o auth client entry.
	 *
	 * @return the user uuid of this o auth client entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this o auth client entry.
	 *
	 * @param userUuid the user uuid of this o auth client entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this o auth client entry.
	 *
	 * @return the user name of this o auth client entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this o auth client entry.
	 *
	 * @param userName the user name of this o auth client entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this o auth client entry.
	 *
	 * @return the create date of this o auth client entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this o auth client entry.
	 *
	 * @param createDate the create date of this o auth client entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this o auth client entry.
	 *
	 * @return the modified date of this o auth client entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this o auth client entry.
	 *
	 * @param modifiedDate the modified date of this o auth client entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the auth request parameters json of this o auth client entry.
	 *
	 * @return the auth request parameters json of this o auth client entry
	 */
	@AutoEscape
	public String getAuthRequestParametersJSON();

	/**
	 * Sets the auth request parameters json of this o auth client entry.
	 *
	 * @param authRequestParametersJSON the auth request parameters json of this o auth client entry
	 */
	public void setAuthRequestParametersJSON(String authRequestParametersJSON);

	/**
	 * Returns the auth server well known uri of this o auth client entry.
	 *
	 * @return the auth server well known uri of this o auth client entry
	 */
	@AutoEscape
	public String getAuthServerWellKnownURI();

	/**
	 * Sets the auth server well known uri of this o auth client entry.
	 *
	 * @param authServerWellKnownURI the auth server well known uri of this o auth client entry
	 */
	public void setAuthServerWellKnownURI(String authServerWellKnownURI);

	/**
	 * Returns the client ID of this o auth client entry.
	 *
	 * @return the client ID of this o auth client entry
	 */
	@AutoEscape
	public String getClientId();

	/**
	 * Sets the client ID of this o auth client entry.
	 *
	 * @param clientId the client ID of this o auth client entry
	 */
	public void setClientId(String clientId);

	/**
	 * Returns the info json of this o auth client entry.
	 *
	 * @return the info json of this o auth client entry
	 */
	@AutoEscape
	public String getInfoJSON();

	/**
	 * Sets the info json of this o auth client entry.
	 *
	 * @param infoJSON the info json of this o auth client entry
	 */
	public void setInfoJSON(String infoJSON);

	/**
	 * Returns the oidc user info mapper json of this o auth client entry.
	 *
	 * @return the oidc user info mapper json of this o auth client entry
	 */
	@AutoEscape
	public String getOIDCUserInfoMapperJSON();

	/**
	 * Sets the oidc user info mapper json of this o auth client entry.
	 *
	 * @param oidcUserInfoMapperJSON the oidc user info mapper json of this o auth client entry
	 */
	public void setOIDCUserInfoMapperJSON(String oidcUserInfoMapperJSON);

	/**
	 * Returns the token request parameters json of this o auth client entry.
	 *
	 * @return the token request parameters json of this o auth client entry
	 */
	@AutoEscape
	public String getTokenRequestParametersJSON();

	/**
	 * Sets the token request parameters json of this o auth client entry.
	 *
	 * @param tokenRequestParametersJSON the token request parameters json of this o auth client entry
	 */
	public void setTokenRequestParametersJSON(
		String tokenRequestParametersJSON);

	@Override
	public OAuthClientEntry cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}