/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.model.ColorScheme;

/**
 * @author Vilmos Papp
 */
public interface ColorSchemeFactory {

	public ColorScheme getColorScheme();

	public ColorScheme getColorScheme(String colorSchemeId);

	public ColorScheme getColorScheme(
		String colorSchemeId, String name, String cssClass);

	public ColorScheme getDefaultRegularColorScheme();

	public String getDefaultRegularColorSchemeId();

}