/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.service.PluginSettingLocalServiceUtil;

/**
 * The extended model base implementation for the PluginSetting service. Represents a row in the &quot;PluginSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PluginSettingImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PluginSettingImpl
 * @see PluginSetting
 * @generated
 */
public abstract class PluginSettingBaseImpl
	extends PluginSettingModelImpl implements PluginSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a plugin setting model instance should use the <code>PluginSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PluginSettingLocalServiceUtil.addPluginSetting(this);
		}
		else {
			PluginSettingLocalServiceUtil.updatePluginSetting(this);
		}
	}

}