/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.RecentLayoutSetBranch;
import com.liferay.portal.kernel.service.RecentLayoutSetBranchLocalServiceUtil;

/**
 * The extended model base implementation for the RecentLayoutSetBranch service. Represents a row in the &quot;RecentLayoutSetBranch&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RecentLayoutSetBranchImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RecentLayoutSetBranchImpl
 * @see RecentLayoutSetBranch
 * @generated
 */
public abstract class RecentLayoutSetBranchBaseImpl
	extends RecentLayoutSetBranchModelImpl implements RecentLayoutSetBranch {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a recent layout set branch model instance should use the <code>RecentLayoutSetBranch</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			RecentLayoutSetBranchLocalServiceUtil.addRecentLayoutSetBranch(
				this);
		}
		else {
			RecentLayoutSetBranchLocalServiceUtil.updateRecentLayoutSetBranch(
				this);
		}
	}

}