/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;

/**
 * The extended model base implementation for the Role service. Represents a row in the &quot;Role_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RoleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RoleImpl
 * @see Role
 * @generated
 */
public abstract class RoleBaseImpl extends RoleModelImpl implements Role {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a role model instance should use the <code>Role</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			RoleLocalServiceUtil.addRole(this);
		}
		else {
			RoleLocalServiceUtil.updateRole(this);
		}
	}

}