/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.service.ServiceComponentLocalServiceUtil;

/**
 * The extended model base implementation for the ServiceComponent service. Represents a row in the &quot;ServiceComponent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ServiceComponentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ServiceComponentImpl
 * @see ServiceComponent
 * @generated
 */
public abstract class ServiceComponentBaseImpl
	extends ServiceComponentModelImpl implements ServiceComponent {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a service component model instance should use the <code>ServiceComponent</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ServiceComponentLocalServiceUtil.addServiceComponent(this);
		}
		else {
			ServiceComponentLocalServiceUtil.updateServiceComponent(this);
		}
	}

}