/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;

/**
 * The extended model base implementation for the User service. Represents a row in the &quot;User_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserImpl
 * @see User
 * @generated
 */
public abstract class UserBaseImpl extends UserModelImpl implements User {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user model instance should use the <code>User</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			UserLocalServiceUtil.addUser(this);
		}
		else {
			UserLocalServiceUtil.updateUser(this);
		}
	}

}